/*=======================================================================
This is an othello game.

THISprogram is under the GPL.

This program requires xforms!

By any kind of problem contact me please under the address:
  nihil@makosteszta.sote.hu
  
    Have a lot of fun!
    
          nihil
=======================================================================*/
          
#include <forms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <unistd.h>
 
/*#####################################################################
#   -level <nr>       [def=1,min=1,max=9]
#   -version
#   -changexo
#   -startx           [def]
#   -starto
#   -blinkx <nr>      [def=0,min=0,max=1]
#   -blinko <nr>      [def=1,min=0,max=1]
#   -blink  <nr>      [def=5,min=1,max=20]
#   -nohelp
#####################################################################*/ 

/*---------------------------------------------------------------------*/

#if defined(MATRIX6)
  #define MATRIX   6
#elif defined(MATRIX8)
  #define MATRIX   8
#elif defined(MATRIX10)
  #define MATRIX   10
#elif defined(MATRIX12)
  #define MATRIX   12
#else  
  #define MATRIX   8
#endif

#define SCHRITTE 8
#define MY_PRGNAME "xothello"
#define VERSION    "Othello-0.01 for X, Jan 8th 1997 by nihil (nihil@makosteszta.sote.hu)"
#define MY_TITLE   "Othello for X v0.01"
#define MY_GAME_X  "Congratulations! You won!"
#define MY_GAME_O  "He-he-he! I won! Practise a bit more!"
#define MY_GAME_XO "Heyyy... This game ended tie!"
#define MY_PASS_X  "You sholud pass!"
#define MY_PASS_O  "I sholud pass!"

typedef enum { Leer, XMan, OMan } ManTyp;
typedef ManTyp TafelArrayTyp[ MATRIX ][ MATRIX ];
typedef int    WerteArrayTyp[ MATRIX ][ MATRIX ];
typedef int    SchrittArrayTyp[ SCHRITTE ]; 

const int SchrittX[ SCHRITTE ] = {  1, 1, 1, 0,-1,-1,-1, 0 };
const int SchrittY[ SCHRITTE ] = { -1, 0, 1, 1, 1, 0,-1,-1 };

/*---------------------------------------------------------------------*/

void BessteSchritt( TafelArrayTyp z, WerteArrayTyp v, 
                    int *x, int *y, int *l, ManTyp w,  int p);
int rnd( int a );
void BessteSchrittOnLevel( TafelArrayTyp z, WerteArrayTyp v,
                           int *x, int *y, int *l, ManTyp w );
ManTyp NegManTyp( ManTyp w );
void SetzeMan( TafelArrayTyp z, int x, int y, ManTyp w );
int  KannNochSchritt( TafelArrayTyp z, ManTyp w );
int  IstPlatzGueltig( TafelArrayTyp z, int x, int y, ManTyp w );
void GetKoordinaten( FL_OBJECT *obj, int *x, int *y );
void BlinkStelle( int x, int y, int blink );
void DrawTafel( TafelArrayTyp z, int *xW, int *oW, ManTyp w, int dOk,
                int a1, int b1, int a2, int b2 );
void DrawStand( int xW, int oW );
void Usage(void);

/*---------------------------------------------------------------------*/

Display   *dpy;
FL_FORM   *form;
FL_FORM   *my_form;
FL_OBJECT *my_field[MATRIX][MATRIX];
FL_OBJECT *ende_but;
FL_OBJECT *new_but;  
FL_OBJECT *info_but;  
FL_OBJECT *x_tab;  
FL_OBJECT *y_tab;

/*---------------------------------------------------------------------*/

int main(int ac, char *av[])
{
  int ax, x, y, xW, oW, a, b, d, xx, yy;
  char *arg;

  int            Level  = 3;
  int            Help   = 1;
  ManTyp         Player  = XMan;
  ManTyp         dranMan = XMan;
  int            blinkNr = 5;
  int            blinkx  = 0;         
  int            blinko  = 1;         
  ManTyp         my_Player;
  ManTyp         my_dranMan;
  TafelArrayTyp  Tafel;
  WerteArrayTyp  Werte;
  FL_OBJECT      *obj;
  char           st[64];

  /*~~~ Argumentums Auswerten ~~~*/
  dpy = fl_initialize(&ac, av, MY_PRGNAME, 0, 0);

  for (ax=1; ax<ac; ax++) 
  { arg = av[ax];

    if (strcmp(arg, "-level") == 0) 
    { if ( (ax+1) >= ac ) { Usage(); }
      Level = strtol(av[++ax], (char **)NULL,0);
      if ( (Level<1) || (Level>9) ) { Usage(); }
    }
    else if (strcmp(arg, "-blink") == 0) 
    { if ( (ax+1) >= ac ) { Usage(); }
      blinkNr = strtol(av[++ax], (char **)NULL,0);
      if ( (blinkNr<0) || (blinkNr>20) ) { Usage(); }
    }
    else if (strcmp(arg, "-blinkx") == 0) 
    { if ( (ax+1) >= ac ) { Usage(); }
      blinkx = strtol(av[++ax], (char **)NULL,0);
      if ( (blinkx<0) || (blinkx>1) ) { Usage(); }
    }
    else if (strcmp(arg, "-blinko") == 0) 
    { if ( (ax+1) >= ac ) { Usage(); }
      blinko = strtol(av[++ax], (char **)NULL,0);
      if ( (blinko<0) || (blinko>1) ) { Usage(); }
    }
    else if (strcmp(arg, "-version") == 0) 
    { printf("\nThis is %s\n\n", VERSION);
      exit(0);
    }
    else if (strcmp(arg, "-changexo") == 0) 
    { Player=NegManTyp(Player);
    }
    else if (strcmp(arg, "-startx") == 0) 
    { dranMan=XMan;
    }
    else if (strcmp(arg, "-starto") == 0) 
    { dranMan=OMan;
    }
    else if (strcmp(arg, "-nohelp") == 0) 
    { Help=0;
    }
    else 
    { Usage();
    }
  }

  my_Player  = Player;
  my_dranMan = dranMan;


  /*~~~~ WerteTabelle auffllen ~~~~*/
  d=(MATRIX-1) / 2;
  for ( x=0; x<MATRIX; x++ )
  { for ( y=0; y<MATRIX; y++ )
    { Werte[x][y]=1;
    }
  }  
  for ( a=0; a<=d; a++ )
  { for ( b=0; b<=d; b++ )
    { x = (MATRIX-1-a)*(MATRIX-1-b)*2;
      if ( (a==0) || (b==0) ) { x=MATRIX-1; }
      if ( (a==1) || (b==1) ) { x=a*b; }
      if ( (a==0) && (b==0) ) { x=(MATRIX-1)*(MATRIX-1); }
      if (a==b) { x=x*4; }
      x=x*2;
      if ( (a==1) && (b==0) ) { x=1; }
      if ( (a==1) && (b==1) ) { x=1; }
      if ( (a==0) && (b==1) ) { x=1; }
      if ( (b==0) && (a>1) && ((a/2)==((a+1)/2)) ) { x=x/2; }     
      if ( (a==0) && (b>1) && ((b/2)==((b+1)/2)) ) { x=x/2; }
      Werte[a][b]=x;     
      Werte[MATRIX-a-1][b]=x;     
      Werte[a][MATRIX-b-1]=x;     
      Werte[MATRIX-a-1][MATRIX-b-1]=x;     
    }
  }  

  /*======================================*/
  /*= WerteTabelle ausschreiben / testen =*/
  /*======================================*/
  /* for ( x=0; x<MATRIX; x++ )           */
  /* { for ( y=0; y<MATRIX; y++ )         */
  /*   { printf( " %3d" , Werte[x][y] );  */
  /*   }                                  */
  /*   NEWLINE;                           */
  /* }                                    */
  /* exit(0);                             */
  /*======================================*/



  /*~~~ XWin initialisieren ~~~*/  

  my_form = fl_bgn_form(FL_NO_BOX,370,320);
  
  obj = fl_add_box(FL_BORDER_BOX,0,0,370,50,"");
  fl_set_object_color(obj,FL_DARKGOLD,FL_COL1);
  fl_set_object_lcol(obj, FL_BLACK);
  obj = fl_add_box(FL_NO_BOX,0,0,310,50, MY_TITLE);
  fl_set_object_lsize(obj,FL_HUGE_SIZE);
  fl_set_object_lstyle(obj,/*FL_ENGRAVED_STYLE+*/FL_BOLD_STYLE);
  fl_set_object_lcol(obj, FL_BLACK);
  obj = fl_add_box(FL_NO_BOX,270,0,100,50,"by nihil\nHungary\n1997.01.08");
  fl_set_object_lcol(obj, FL_BLACK);

  obj = fl_add_box(FL_BORDER_BOX,0,50,270,270,"");
  fl_set_object_color(obj,FL_SLATEBLUE,FL_COL1);

  obj = fl_add_box(FL_BORDER_BOX,9,59,
                   ((250/MATRIX)*MATRIX)+2,((250/MATRIX)*MATRIX)+2,"");

  obj = fl_add_box(FL_BORDER_BOX,270,50,100,170,"");
  fl_set_object_color(obj,FL_DARKCYAN,FL_COL1);

  new_but=fl_add_button(FL_NORMAL_BUTTON,  280,  70, 80, 30,"New Game");
  fl_set_object_lsize(new_but,FL_NORMAL_SIZE);
  info_but=fl_add_button(FL_NORMAL_BUTTON, 280, 120, 80, 30,"Info");
  fl_set_object_lsize(info_but,FL_NORMAL_SIZE);
  ende_but=fl_add_button(FL_NORMAL_BUTTON, 280, 170, 80, 30,"The End");
  fl_set_object_lsize(ende_but,FL_NORMAL_SIZE);

  obj = fl_add_box(FL_BORDER_BOX,270,220,100, 100,"");
  fl_set_object_color(obj,FL_DARKCYAN,FL_COL1);

  obj = fl_add_box(FL_NO_BOX,270,225,100,20,"State:");
  fl_set_object_color(obj,FL_DARKCYAN,FL_COL1);
  fl_set_object_lsize(obj,FL_NORMAL_SIZE);

  obj = fl_add_box(FL_NO_BOX,275,245,25,30,"X:");
  fl_set_object_color(obj,FL_DARKCYAN,FL_COL1);
  fl_set_object_lsize(obj,FL_NORMAL_SIZE);

  x_tab = fl_add_box(FL_BORDER_BOX,300,250,60,20,"0");
  fl_set_object_color(x_tab,FL_LEFT_BCOL,FL_COL1);
  fl_set_object_lsize(x_tab,FL_NORMAL_SIZE);
  
  obj = fl_add_box(FL_NO_BOX,275,275,25,30,"O:");
  fl_set_object_color(obj,FL_DARKCYAN,FL_COL1);
  fl_set_object_lsize(obj,FL_NORMAL_SIZE);

  y_tab = fl_add_box(FL_BORDER_BOX,300,280,60,20,"0");
  fl_set_object_color(y_tab,FL_LEFT_BCOL,FL_COL1);
  fl_set_object_lsize(y_tab,FL_NORMAL_SIZE);

  for ( x=0; x<=MATRIX-1; x++ ) {
    for ( y=0; y<=MATRIX-1; y++ ) {
      my_field[x][y]=fl_add_button( FL_NORMAL_BUTTON, 
        10+(x*(250/MATRIX)),60+(y*(250/MATRIX)),250/MATRIX,250/MATRIX,"");
      fl_set_object_boxtype( my_field[x][y], FL_BORDER_BOX );
      fl_set_object_color( my_field[x][y], FL_LEFT_BCOL, FL_MCOL);
      fl_set_object_lstyle( my_field[x][y], FL_FIXEDBOLD_STYLE);
      fl_set_object_lsize( my_field[x][y], FL_LARGE_SIZE );
    };
  };
  
  fl_end_form();
  fl_show_form( my_form, FL_PLACE_SIZE, FL_FULLBORDER, MY_PRGNAME );

  do {  
  
    /*~~~ Tafel initialisieren ~~~*/  
    for ( x=0; x<MATRIX; x++ )
    { for ( y=0; y<MATRIX; y++ )
      { Tafel[x][y]=Leer;
      }
    }  
    x = (MATRIX-1) / 2;
    y = (MATRIX-1) / 2;
    Tafel[x][y] = dranMan;
    Tafel[x+1][y+1] = dranMan;
    Tafel[x][y+1] = NegManTyp(dranMan);
    Tafel[x+1][y] = NegManTyp(dranMan);


    /*~~~ Player initialisieren ~~~*/  
    Player = my_Player;
    dranMan = my_dranMan;

    x=-1; y=-1; a=-1; b=-1; xW=0; oW=0;
    DrawTafel( Tafel, &xW, &oW, Player, (dranMan==Player) && (Help==1), x, y, a, b);
    DrawStand( xW, oW );

    do 
    { 
      /*...............COMPUTER...............*/
      if ( dranMan!=Player )
      { if ( KannNochSchritt( Tafel, dranMan ) != 0 )
        { BessteSchritt( Tafel, Werte, &a, &b, &d, dranMan, Level );
          SetzeMan( Tafel, a, b, dranMan );
          if (blinko==1) BlinkStelle( a, b, blinkNr );
        }
        else
        { fl_show_message( MY_TITLE, MY_PASS_O, ""); };
          dranMan=NegManTyp( dranMan );
      }
      DrawTafel( Tafel, &xW, &oW, Player, (dranMan==Player) && (Help==1), x, y, a, b );
      DrawStand( xW, oW );
      /*......................................*/

      if ( (( KannNochSchritt(Tafel,XMan)+KannNochSchritt(Tafel,OMan)) == 0) ||
           ((xW+oW) >= (MATRIX*MATRIX)) ) { break; };
        
      if ( dranMan==Player )
      { if ( KannNochSchritt( Tafel, dranMan ) == 0 )
        { fl_show_message( MY_TITLE, MY_PASS_X, "");
          dranMan=NegManTyp( dranMan );
          DrawTafel( Tafel, &xW, &oW, Player, (dranMan==Player) && (Help==1), x, y, a, b );
          DrawStand( xW, oW );
          continue;
        };
       }; 

      obj = fl_do_forms(); 
     
      if ( obj == ende_but ) 
        { fl_hide_form( my_form );
          return 0; }

      if ( obj == new_but ) 
        { break; }

      if ( obj == info_but ) 
        { sprintf( st, "Active level: %3d", Level);
          fl_show_message(MY_TITLE,"Written by nihil  ***  Hungary  ***  mailto:nihil@makosteszta.sote.hu",st);
          continue; }

      /*...............PLAYER...............*/
      if ( dranMan==Player )
      { if ( KannNochSchritt( Tafel, dranMan ) != 0 )
        { GetKoordinaten( obj, &xx, &yy );
          if ( IstPlatzGueltig( Tafel, xx, yy, Player )!=0 )
          { x=xx; y=yy;
            SetzeMan( Tafel, x, y, dranMan );
            dranMan=NegManTyp( dranMan );
            if (blinkx==1) BlinkStelle( x, y, blinkNr );
            DrawTafel( Tafel, &xW, &oW, Player, (dranMan==Player) && (Help==1), x, y, a, b );
            DrawStand( xW, oW );
          }
        }
      };
      /*......................................*/

    
      if ( (( KannNochSchritt(Tafel,XMan)+KannNochSchritt(Tafel,OMan)) == 0) ||
           ((xW+oW) >= (MATRIX*MATRIX)) ) { break; };

     } while (1);

     if ( obj != new_but )
     { sprintf( st, " The state: X:%3d O:%3d", xW, oW );
       if ( xW==oW) 
         { fl_show_message( MY_TITLE, MY_GAME_XO, st); }
       else if ( ( (Player==XMan) && ( xW > oW ) ) ||
                 ( (Player==OMan) && ( xW < oW ) ) )
         { fl_show_message( MY_TITLE, MY_GAME_X, st); }
       else 
         { fl_show_message( MY_TITLE, MY_GAME_O, st); }
     };              

  } while(1);

  fl_hide_form( my_form );
  return 0;
}

/*---------------------------------------------------------------------*/

void BessteSchritt( TafelArrayTyp z, WerteArrayTyp v, 
                    int *x, int *y, int *l, ManTyp w, int p )
{ int l1, x1, y1;
  int c, d, q;
  int c1,d1, q1;
  TafelArrayTyp z1;

  q=INT_MIN;
  if ( p<=1 ) {
    BessteSchrittOnLevel( z, v, &*x, &*y, &*l, w );
  }
  else {
    
    for (c=0; c<MATRIX; c++) {
      for (d=0; d<MATRIX; d++) {

        q1 = IstPlatzGueltig( z, c, d, w);
        if (q1 != 0) {
            
          for (c1=0; c1<MATRIX; c1++) {
            for (d1=0; d1<MATRIX; d1++) { z1[c1][d1]=z[c1][d1]; }
          }
          SetzeMan( z1, c, d, w );
          BessteSchritt( z1, v, &x1, &y1, &l1, NegManTyp(w), p-1 );
          q1 += v[c][d];
          q1 -= l1/4;
          if (q1>q) { q=q1; *x=c; *y=d; }
          else if (q1==q) {
             if ( rnd(100)>40 ) { q=q1; *x=c; *y=d; } 
          }          
        }
      }
    }
    *l=q;
  }

}

/*---------------------------------------------------------------------*/

int rnd( int a )
{
  return( (int) ( ((float)a)*rand()/(RAND_MAX+1.0)) );
}


/*---------------------------------------------------------------------*/

void BessteSchrittOnLevel( TafelArrayTyp z, WerteArrayTyp v,
                           int *x, int *y, int *l, ManTyp w )
{ int a, b, c, d, q, q1;
  a=0;
  b=0;
  q=0;  
  for ( c=0; c<MATRIX; c++ ) {
    for ( d=0; d<MATRIX; d++ ) {
      q1=IstPlatzGueltig( z, c, d, w );
      if ( q1!=0 ) { q1 += v[c][d]; }
      if (q1>q) { q=q1; a=c; b=d; }
      else if (q1==q){
        if ( rnd(100)>40 ) { q=q1; a=c; b=d; }      
      }   
    }
  }
  *x=a;
  *y=b;
  *l=q;   
}


/*---------------------------------------------------------------------*/

ManTyp NegManTyp( ManTyp w )
{ if (w==XMan) { return(OMan); }
  if (w==OMan) { return(XMan); }
  return( Leer );
}

/*---------------------------------------------------------------------*/

void SetzeMan( TafelArrayTyp z, int x, int y, ManTyp w )
{ int a,b,c, q;
  if ( z[x][y] != Leer ) exit(-1);
  for ( c=0; c<8; c++ )
  { q=0; a=x; b=y;
    while (0==0)
    { a += SchrittX[c];
      if (a<0)           { q=0; break; }
      if (a>(MATRIX-1))  { q=0; break; }
      b += SchrittY[c];
      if (b<0)           { q=0; break; }
      if (b>(MATRIX-1))  { q=0; break; }
      if (z[a][b]==Leer) { q=0; break; }
      if (z[a][b]==w)    { break; }
      q += 1;      
    }
    a=x; b=y;
    while (q>0)
    { a += SchrittX[c];
      b += SchrittY[c];
      z[a][b]=w;
      q -= 1;
    }
  }
  z[x][y]=w;
}

/*---------------------------------------------------------------------*/

int KannNochSchritt( TafelArrayTyp z, ManTyp w )
{ int x,y,n;
  n=0;
  for ( x=0; x<MATRIX; x++ )
  { for ( y=0; y<MATRIX; y++ )
    { n += IstPlatzGueltig( z, x, y, w );
    }
  }  
  return( n );
}

/*---------------------------------------------------------------------*/

int IstPlatzGueltig( TafelArrayTyp z, int x, int y, ManTyp w )
{ int a,b,c, q1,q2;
  if ( z[x][y] != Leer ) return( 0 );
  q1=0;
  for ( c=0; c<8; c++ )
  { q2=0; a=x; b=y;
    while (0==0)
    { a += SchrittX[c];
      if (a<0) { q2=0; break; }
      if (a>(MATRIX-1)) { q2=0; break; }
      b += SchrittY[c];
      if (b<0) { q2=0; break; }
      if (b>(MATRIX-1)) { q2=0; break; }
      if (z[a][b]==Leer) { q2=0; break; }
      if (z[a][b]==w) { break; }
      q2 += 1;      
    }
    q1 += q2; 
  }
  return( q1 );
}
/*---------------------------------------------------------------------*/

void DrawStand( int xW, int oW )
{ char st[6];

  sprintf( st, "%3d", xW );
  fl_set_object_label( x_tab, st);

  sprintf( st, "%3d", oW );
  fl_set_object_label( y_tab, st);

}

/*---------------------------------------------------------------------*/

void GetKoordinaten( FL_OBJECT *obj, int *x, int *y )
{ int a,b;
  *x=-1;
  *y=-1;
  for ( a=0; a<=MATRIX-1; a++ ) {
    for ( b=0; b<=MATRIX-1; b++ ) {
      if ( my_field[a][b] == &*obj ) { *x=a; *y=b; };
    };
  };
}

/*---------------------------------------------------------------------*/

void BlinkStelle( int x, int y, int blink )
{ int a;

  for ( a=0; a<blink; a++ )
  { fl_set_object_color( my_field[x][y], FL_BLACK, FL_MCOL);
    XFlush(fl_get_display());
    usleep(100000);
    fl_set_object_color( my_field[x][y], FL_WHITE, FL_MCOL);    
    XFlush(fl_get_display());
    usleep(100000);
  }
  fl_set_object_color( my_field[x][y], FL_LEFT_BCOL, FL_MCOL);    

}

/*---------------------------------------------------------------------*/

void DrawTafel( TafelArrayTyp z, int *xW, int *oW, ManTyp w, int dOk,
                int a1, int b1, int a2, int b2 )
{ int x,y;  

  *xW=0;
  *oW=0;


  for ( y=0; y<MATRIX; y++ )
  { for ( x=0; x<MATRIX; x++ )
    { if ( ((x==a1) && (y==b1)) || ((x==a2) && (y==b2)) ) 
        { fl_set_object_color( my_field[x][y], FL_MCOL, FL_MCOL); }
      else  
         { fl_set_object_color( my_field[x][y], FL_LEFT_BCOL, FL_MCOL); };
      if ( z[x][y]==XMan ) 
       { fl_set_object_label( my_field[x][y], "X");
         fl_set_object_lsize( my_field[x][y], FL_LARGE_SIZE );
         fl_set_object_lcol( my_field[x][y], FL_BLUE );
         *xW+=1;
       }
      else if ( z[x][y]==OMan ) 
      { fl_set_object_label( my_field[x][y], "O");
        fl_set_object_lsize( my_field[x][y], FL_LARGE_SIZE );
        fl_set_object_lcol( my_field[x][y], FL_RED );
        *oW+=1; 
      }
      else 
      { if ( (dOk!=0) && (IstPlatzGueltig( z, x, y, w )!=0) )
        { fl_set_object_label( my_field[x][y], "*");
          fl_set_object_lsize( my_field[x][y], FL_NORMAL_SIZE );
          fl_set_object_lcol( my_field[x][y], FL_BLACK ); }
        else 
        { fl_set_object_label( my_field[x][y], "");
          fl_set_object_lsize( my_field[x][y], FL_LARGE_SIZE );
          fl_set_object_lcol( my_field[x][y], FL_BLACK ); }
      }
    }
  }
}        

/*---------------------------------------------------------------------*/

#define USEPRT(msg) fprintf(stderr, msg)

void
Usage(void)
{
    USEPRT("Usage: othello [options]\n\n");
    USEPRT("Options:\n");
    USEPRT("  -level <levelnr>       [default=3, min=1, max=9]\n");
    USEPRT("  -changexo\n");
    USEPRT("  -startx                [default]\n");
    USEPRT("  -starto\n");
    USEPRT("  -blink  <nr>           [def=5,min=1,max=20]\n");
    USEPRT("  -blinkx <nr>           [def=0,min=0,max=1]\n");
    USEPRT("  -blinko <nr>           [def=1,min=0,max=1]\n");
    USEPRT("  -nohelp\n");   
    USEPRT("  -version\n");
    exit(1);
}
                                                        
/*---------------------------------------------------------------------*/

