/*
 * Copyright (c) 1997, 1999, 2000, Mark Buser.
 * Copyright (c) 2001, 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/option.c,v 1.14 2004/12/27 08:08:13 danny Exp $
 */
#include <stdlib.h>
#include <string.h>

#include <Xm/XmAll.h>

#include "about.h"
#include "fileXq.h"
#include "help.h"
#include "optnet.h"
#include "opttick.h"
#include "optdetail.h"
#include "optupdate.h"
#include "pixmap.h"
#include "server.h"
#include "tape.h"
#include "xutil.h"
#include "session.h"

/* Local Globals */
Widget	Detail_dialog = NULL;       /* set from main */
Widget	AlertDialog = NULL;

static Widget Update_dialog = NULL;
static Widget Tape_dialog = NULL;
static Widget Net_dialog = NULL;
static Widget Log_dialog = NULL;

static Widget createAlertDialog(void);
/* 
** Main app menu support 
*/

/* Create appropriate dialog when an option is selected */

/* ARGSUSED */
void optionCB( Widget w, int menu_pos, XtPointer call_data)
{
	Dimension	height, width, border;
	Widget		tf;
	char		*s;

	switch (menu_pos) {
	case 0: /* Network setup */
		if (Net_dialog == NULL)
			Net_dialog = createNetDialog();

		XtManageChild(Net_dialog);
		XtPopup(Net_dialog, XtGrabNone);
		break;

	case 1: /* Ticker symbol dialog */
		createTickDialog();
		break;

	case 2: /* Tape setup */
		if (Tape_dialog == NULL) {
			Widget pane, frame, form, button, scale;
			int smooth, delay;

			tapeGetScroll(&smooth, &delay);

			Tape_dialog = XtVaCreatePopupShell("OptionTape", xmDialogShellWidgetClass,
					GetTopShell(w), NULL);

			/*
			** This allows the frame to work and the buttons to not cause
			** the dialog to auto unmanage.  Where is this documented?
			*/
			pane = XtVaCreateWidget("TapePane", xmPanedWindowWidgetClass, Tape_dialog,
					XmNsashWidth,	1,
					XmNsashHeight,	1,
					NULL);

			frame = XtVaCreateManagedWidget("Tapeframe", xmFrameWidgetClass, pane,
					NULL);

			form = XtVaCreateWidget("Tapeform", xmFormWidgetClass, frame, NULL);
			button = XtVaCreateManagedWidget("button_0", xmPushButtonWidgetClass, form,
					XmNlabelType,	XmPIXMAP,
					XmNlabelPixmap, GetPixmap(PEJECT, NORMAL, XtDisplay(form)),
					XmNlabelInsensitivePixmap,
							GetPixmap(PEJECT, INSENS, XtDisplay(form)),
					XmNtopAttachment,	XmATTACH_FORM,
					XmNleftAttachment,	XmATTACH_FORM,
					NULL);
			XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)procTape, NULL);
			button = XtVaCreateManagedWidget("button_1", xmPushButtonWidgetClass, form,
					XmNlabelType,	XmPIXMAP,
					XmNlabelPixmap,	GetPixmap(PPLAY, NORMAL, XtDisplay(form)),
					XmNlabelInsensitivePixmap,
							GetPixmap(PPLAY, INSENS, XtDisplay(form)),
					XmNtopAttachment,	XmATTACH_FORM,
					XmNleftAttachment,	XmATTACH_WIDGET,
					XmNleftWidget,	button,
					NULL);
			XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) procTape,
					(XtPointer) 1);
			button = XtVaCreateManagedWidget("button_2", xmPushButtonWidgetClass, form,
					XmNlabelType,	XmPIXMAP,
					XmNlabelPixmap, GetPixmap(PSTOP, NORMAL, XtDisplay(form)),
					XmNlabelInsensitivePixmap,
						GetPixmap(PSTOP, INSENS, XtDisplay(form)),
					XmNtopAttachment,	XmATTACH_FORM,
					XmNleftAttachment,	XmATTACH_WIDGET,
					XmNleftWidget,	button,
					NULL);
			XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) procTape,
					(XtPointer) 2);
			button = XtVaCreateManagedWidget("button_3", xmToggleButtonWidgetClass, form,
					XmNtopAttachment,	XmATTACH_FORM,
					XmNleftAttachment,	XmATTACH_WIDGET,
					XmNleftWidget,		button,
					XmNrightAttachment,	XmATTACH_FORM,
					NULL);
			XtAddCallback(button, XmNvalueChangedCallback, (XtCallbackProc)procTape,
					(XtPointer) 3);
			XmToggleButtonSetState(button, (smooth)?XmSET:XmUNSET, False);

			scale = XtVaCreateManagedWidget("TapeScale", xmScaleWidgetClass, form, 
					XmNvalue,		delay,
					XmNtopAttachment,	XmATTACH_WIDGET,
					XmNtopWidget,		button,
					XmNleftAttachment,	XmATTACH_FORM,
					XmNrightAttachment,	XmATTACH_FORM,
					XmNbottomAttachment,	XmATTACH_FORM,
					NULL);
			XtAddCallback(scale, XmNvalueChangedCallback, (XtCallbackProc) procTape,
					(XtPointer) 4);
			XtManageChild(form);
			XtManageChild(pane);

			/* Prevent pane from changing size */
			XtVaGetValues(Tape_dialog,
					XmNwidth, &width,
					XmNheight, &height,
					XmNborderWidth, &border,
					NULL);

			XtVaSetValues(Tape_dialog,
					XmNminWidth,  width +  border,
					XmNmaxWidth,  width +  border,
					XmNminHeight, height + border,
					XmNmaxHeight, height + border,
					NULL);
			}

			XtManageChild(Tape_dialog);
			XtPopup(Tape_dialog, XtGrabNone);
			break;

	case 3: /* Select update params */
		if (Update_dialog == NULL)
			Update_dialog = createUpdateDialog();

		XtSetMappedWhenManaged(Update_dialog, True);
		XtManageChild(Update_dialog);
		XtPopup(Update_dialog, XtGrabNone);
		break;

	case 4: /* Select interesting params */
		if (Detail_dialog == NULL)
			Detail_dialog = createDetailDialog();
		Detail_dialog = XtNameToWidget(per->Toplevel, "*OptionDetail");

		XtSetMappedWhenManaged(Detail_dialog, True);
		XtManageChild(Detail_dialog);
		XtPopup(Detail_dialog, XtGrabNone);
		break;

	case 5: /* File logging options */
		if (Log_dialog == NULL)
			Log_dialog = createLogDialog();

		XtSetMappedWhenManaged(Log_dialog, True);
		XtManageChild(Log_dialog);
		XtPopup(Log_dialog, XtGrabNone);

		break;

	case 6:	/* Alert options */
		if (AlertDialog == NULL)
			AlertDialog = createAlertDialog();

#define	DFT_TXT	"echo \"symbol [%n] value %v low %l high %h\" | mail -s \"Xquote alert : %n value %v\" me@myisp.net"

		/* initialise the text field */
		tf = XmSelectionBoxGetChild(AlertDialog, XmDIALOG_TEXT);
		s = prefGetMailCommand();
		if (s == NULL)
			s = DFT_TXT;
		XmTextFieldSetString(tf, s);

		XtManageChild(AlertDialog);
		break;
	default:
		break;
	}
}

/* ARGSUSED */
void popupCB( Widget w, int menu_pos, XtPointer call_data)
{
  /* Funnel action to correct handler for other menus */
  switch (menu_pos) {

    case 0: /* Update now  */
    case 1: /* Stop update */
    case 2: /* Save session */
    case 3: /* Log to File  */
    case 4: /* Stop logging */
    case 5: /* Clear log    */
	    fileCB (w, (XtPointer)menu_pos, call_data);
	    break;

    case 12: aboutCB (w, (XtPointer)menu_pos, call_data);
            break;

    case 13: helpCB (w, (XtPointer)menu_pos, call_data);
            break;

    default: /* Option menus */
	    optionCB(w, menu_pos-6, call_data);
	    break;
  }
}

static void AlertDialogOk(Widget w, XtPointer client, XtPointer call)
{
	Widget	tf;
	char	*s;

	tf = XmSelectionBoxGetChild(AlertDialog, XmDIALOG_TEXT);
	if (tf) {
		s = XmTextFieldGetString(tf);
		if (s)
			prefSetMailCommand(s);
	}
	XtUnmanageChild(AlertDialog);
}

static void AlertDialogCancel(Widget w, XtPointer client, XtPointer call)
{
	XtUnmanageChild(AlertDialog);
}

static Widget createAlertDialog(void)
{
	Widget	d, p, hb;
	Arg	al[3];
	int	ac;

	p = GetTopShell(per->Toplevel);

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, False); ac++;
	d = XmCreatePromptDialog(p, "alert_dialog", al, ac);
	XtAddCallback(d, XmNokCallback, AlertDialogOk, NULL);
	XtAddCallback(d, XmNcancelCallback, AlertDialogCancel, NULL);

	/* No help button for now */
	hb = XmSelectionBoxGetChild(d, XmDIALOG_HELP_BUTTON);
	XtDestroyWidget(hb);

	return d;
}
