/*
 * Copyright (c) 1997, 2000, Mark Buser.
 * Copyright (c) 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/parse.c,v 1.7 2004/11/24 22:32:26 danny Exp $
 */
#undef	DEBUG

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <Xm/XmAll.h>
#include "server.h"

/* 
** Find first text not in an HTML tag, skip any blanks, return pointer
** to this "clear" text or NULL if no "clear" text.
*/
static char *skipTag ( char *html )
{
  char *look, *end;
  char *result;

  look = html;
  end = html + strlen(html);
  do {
    result = strchr ( look, '>' );  /* find end of tag */
    if (result) {
      result++;                     /* increment past tag */
      while ( result < end && isspace(result[0]))
        result++;                   /* skip white space */

      if ( result < end && (isalnum(result[0]) || strspn(result, "+-")) )    
	return(result);             /* send "clear" text back */
      else
	look = result;
    }
  } while (look && look < end );

  return (NULL);
}

static void RegisterResult(QUERY_STRUCT *result, int ix, char *str, int len)
{
	char *append;
	char	**p = &result->values[ix];

#ifdef	DEBUG
	{
		int i;
		fprintf(stderr, "  RegisterResult(%s, ", FieldName(ix));
		for (i=0; i<len; i++)
			fprintf(stderr, "%c", str[i]);
		fprintf(stderr, ")\n");
	}
#endif
	if (*p) {
		int oldlen = strlen(*p);
		*p = XtRealloc(*p, (oldlen + len + 1) * sizeof(char));
		append = *p + oldlen;
	} else {
		*p = XtCalloc(len + 1, sizeof(char));
		append = *p;
	}
	strncpy(append, str, len);
	append[len] = '\0';
}

QUERY_STRUCT *findPattern(char *start)
{
	QUERY_STRUCT *result;
	char *cur;

	char *pattern;
	char *nextpattern;

	int i, count, size;

	result = (QUERY_STRUCT *) XtCalloc(1, sizeof(QUERY_STRUCT));
	if (result == (QUERY_STRUCT *)NULL)
		return (result);

#ifdef	DEBUG
	fprintf(stderr, "findPattern()\n");
#endif

	for (i=DETAIL_PRICE; i < DETAIL_NUM_QUERY_VALUES; i++) {
		result->values[i] = NULL; 

		pattern = XtNewString(getServer(i));
		if (pattern) {
			cur = start;
			nextpattern = strtok (pattern, ",");
			do {
				if (strcasecmp(nextpattern, "SKIPH") == 0)
					cur = skipTag(cur);
				else if (strcasecmp(nextpattern, "SKIPC") == 0)
					cur++;
				else if (strcasecmp(nextpattern, "DIGIT") == 0) {
					count = strspn(cur, "0123456789,.-+");
					if (count) {
						RegisterResult(result, i, cur, count);
						cur += count;
					}
				} else if (strcasecmp(nextpattern, "OPTHFRACT") == 0) {
					/* Assume digits <tag> / <tag> digits */
					char *fract;

					count = strspn (cur, "0123456789,.-+");
					if (count) {                        /* found a fraction */
						fract = XtCalloc (count +3, sizeof(char));
						sprintf (fract, " %.*s/", count, cur);
						size = strlen(fract);

						cur = skipTag(cur);  /* skiptag will not stop at '/' */
						count = strspn (cur, "0123456789,.");
						if (count) {                      /* flag as error if 0? */
							fract = XtRealloc (fract, (size+count+1) * sizeof(char));
							strncat ( fract, cur, count);
							fract[size+count] = '\0';
							size = strlen(fract);
						}
						RegisterResult(result, i, fract, size);
						XtFree (fract);
					}
				} else if (strcasecmp(nextpattern, "OPTFRACT") == 0) {
					/* Assume digits / digits */
					int tag;

					/* check for [0-9/ ]? instead of tag? */
					tag = strcspn (cur, "<&");
					if (tag) {
					RegisterResult(result, i, cur, tag);
					}
				} else if (strcasecmp(nextpattern, "STRING") == 0) {
					int tag;
					tag = strcspn (cur, "<&\n");
					if (tag) {
						RegisterResult(result, i, cur, tag);
					}
				} else if (strncasecmp(nextpattern, "STRING(", 7) == 0) {
					char	*endit = nextpattern + 7;
					int	len = strcspn(endit,")"), tag;
					char	*reject = malloc(len+4);

					/*
					 * Concatenate the HTML tag detection, and the
					 * parameter passed in STRING(X)
					 */
					strncpy(reject, endit, len);
					reject[len] = '\0';
					strcat(reject, "<&\n");

					/*
					 * Find the tag in the HTML
					 */
					tag = strcspn(cur, reject);
					if (tag) {
						RegisterResult(result, i, cur, tag);
					}
					free(reject);
				} else if (strncasecmp(nextpattern, "OPTSTRING:", 10) == 0) {
					char *matchpattern, *limitpattern, *subst;
					char *match, *limit;
					int matchlen, limitlen;
					matchpattern = nextpattern + 10;
					matchlen = strcspn (matchpattern, ":");
					limitpattern = matchpattern + matchlen;
					if (*limitpattern == ':')  *limitpattern++ = '\0';
						limitlen = strcspn (limitpattern, ":");
					subst = limitpattern + limitlen;
					if (*subst == ':') 
						*subst++ = '\0';

					limit = NULL;
					if (*limitpattern != '\0') {
						limit = strstr (cur, limitpattern);
					}

					match = cur;  /* Treat no matchpattern as always matching */
					if (*matchpattern != '\0') {
						match = strstr (cur, matchpattern);
						if (limit != NULL && match != NULL
								&& match + matchlen > limit) {
							match = NULL;
						}
					}

					if (match != NULL) {
						if (*subst == '\0') {
							subst = matchpattern;
						}
						RegisterResult(result, i, subst, strlen(subst));
					}
				} else if (strcasecmp(nextpattern, "NULL") == 0)
					break;
				else {  /* pattern search */
					cur = strstr (cur, nextpattern);
					if (cur)
						cur += strlen (nextpattern);
				}
			} while ( cur && (nextpattern=strtok(NULL, ",")) );
			XtFree (pattern);
		}
	}
	return (result);
}

/* Free a QUERY_STRUCT contents and the structure itself */
void freePattern (QUERY_STRUCT *data)
{
	int i;

	if (data) {
		for (i=DETAIL_PRICE; i < DETAIL_NUM_QUERY_VALUES; i++)
			XtFree (data->values[i]);
			XtFree ((char *)data);
	}
}

char *findNews(char *html)
{
	char *cur, *end, *partial; 
	char *result = NULL;
	int tag, len = 0;

	cur = html;

	if ((cur = strstr (cur, "NAME=\"News\""))) /* Find News */
		if ((cur += strlen ("NAME=\"News\"")))
			end = strstr (cur, "pagetop.gif");       /* End of section */

	if (cur == NULL || end == NULL)
		return ("No News Is Good News!");

	do {
		cur = strstr (cur, "pushpin.gif");         /* Find headline */
		if (cur)
			cur += strlen ("pushpin.gif");
		else
			break;

		cur = skipTag(cur);                        /* Skip to date */

		tag = strcspn (cur, "<&");                 /* Copy to next tag */
		if (tag) {
			partial = XtCalloc (tag +2, sizeof(char));
			sprintf( partial, "%.*s\n", tag, cur);

			result = XtRealloc (result, len + strlen(partial) +1);

			if (len == 0)
				strcpy( result, partial );
			else
				strcat( result, partial );
			len += strlen(partial);

			XtFree( partial );
		}
	} while (cur < end);

	return (result);
}
