/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: autopilot.c,v 1.1 1999/07/10 13:38:19 rich Exp $
 */

#include <math.h>

#include "xracer.h"

#define AUTOPILOT_LOOKAHEAD 10
#define TURN_FACTOR 3

void
autopilot (int cr)
{
  int seg;
  GLfloat left[3], t, angle;

  /* Current segment. */
  seg = pilot[cr].seg[0];

  /* Look a few segments ahead. */
  seg += AUTOPILOT_LOOKAHEAD;
  if (seg >= track->nr_segments) seg -= track->nr_segments;

  /* Left-pointing vector. */
  left[0] = pilot[cr].posn[1][0] - pilot[cr].posn[2][0];
  left[1] = pilot[cr].posn[1][1] - pilot[cr].posn[2][1];
  left[2] = pilot[cr].posn[1][2] - pilot[cr].posn[2][2];

  /* Work out angle between current left direction and forwards vector
   * in this segment.
   */
  angle = angle_between (left, track->segments[seg].forwards);

  /* OK. Now we have the angle between the left side of the craft
   * and the forwards vector along the track.
   * So, when the craft is pointing forwards, angle = PI/2
   *            "     "     "       left,     angle = PI
   *            "     "     "       back,     angle = PI/2
   *            "     "     "       right,    angle = 0.
   * From this we can see that if angle < PI/2, we are pointing
   * right, and so should turn left. If angle > PI/2, we are
   * pointing left, and so should turn right.
   */
  if (angle < M_PI/2)
    {
      t = asin (M_PI/2 - angle); /* t = [0..1] */
      t *= TURN_FACTOR; if (t > 1) t = 1;
      control[cr].autopilot_x = - t * 128;
    }
  else if (angle >= M_PI/2)
    {
      t = asin (angle - M_PI/2); /* t = [0..1] */
      t *= TURN_FACTOR; if (t > 1) t = 1;
      control[cr].autopilot_x = t * 128;
    }

  control[cr].autopilot_flag = 1;
  control[cr].autopilot_y = 0;
  control[cr].accelerate = 1;
}
