/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: craft.c,v 1.8 1999/07/21 22:16:48 rich Exp $
 */

#include <stdio.h>
#include <stdlib.h>

#include "xracer.h"

#define CRAFT_SCALE 9.0

/* This craft was generated by hand from an AC3D modeller
 * file. In future, there will be a tool to import generate
 * this information automatically from a modeller description
 * and save to a `craft' file. This source file will then
 * become responsible for reading in craft files.
 */

/* These vertices are arranged (by accident, not design) so that:
 * +X points rightwards.
 * +Y points upwards.
 * +Z points to the nose.
 */
static GLfloat vertices[][3] = {
  {-3.0555556, -1.5, -5.66667},	/* 0 */
  {-1.0555556, -1.5, -6.66667},	/* 1 */
  {0.9444444,  -1.5, -6.66667},	/* 2 */
  {2.9444444,  -1.5, -5.66667},	/* 3 */
  {0.9444444,  -1.5, 10.33333},	/* 4 */
  {-0.0555556, -1.5, 2.33333},	/* 5 */
  {-1.0555556, -1.5, 10.33333},	/* 6 */
  {-1.05556,    1.5, -4.66667},	/* 7 */
  {0.9444444,   1.5, -4.66667}	/* 8 */
};

#define nr_vertices (sizeof vertices / sizeof vertices[0])

static struct { int v; GLfloat r, s; } triangles[] = {
  /* craft1-under.jpg */
  {0, 0, 0.941176},
  {1, 0.333333, 1},
  {2, 0.666667, 1},

  {0, 0, 0.941176},
  {2, 0.666667, 1},
  {3, 1, 0.941176},

  {3, 1, 0.941176},
  {4, 0.666667, 0},
  {5, 0.5, 0.470588},

  {0, 0, 0.941176},
  {3, 1, 0.941176},
  {5, 0.5, 0.470588},

  {0, 0, 0.941176},
  {5, 0.5, 0.470588},
  {6, 0.333333, 0},

  {0, 0.5, 0},
  {7, 0, 1},
  {1, 1, 0},

  /* craft1-back-side.jpg */
  {7, 0, 1},
  {8, 1, 1},
  {2, 1, 0},

  /* craft1-back-side.jpg */
  {7, 1, 1},
  {2, 1, 0},
  {1, 0, 0},

  /* craft1-back-side.jpg */
  {8, 0, 1},
  {3, 0.5, 0},
  {2, 1, 0},

  /* craft1-side.jpg */
  {3, 1, 0},
  {4, 0, 0},
  {8, 0.9375, 1},

  /* craft1-side.jpg */
  {0, 1, 0},
  {6, 0, 0},
  {7, 0.9375, 1},

  /* craft1-inner-side.jpg */
  {4, 0, 0},
  {8, 1, 1},
  {5, 0.533333, 0},

  /* craft1-inner-side.jpg */
  {6, 0, 0},
  {7, 1, 1},
  {5, 0.533333, 0},

  /* craft1-windscreen.jpg */
  {5, 0.5, 0},
  {7, 0, 1},
  {8, 1, 1}
};

#define nr_triangles (sizeof triangles / sizeof triangles[0] / 3)

static struct { int tex_index; } triangle_textures[] = {
  { 0 },
  { 0 },
  { 0 },
  { 0 },
  { 1 },
  { 1 },
  { 1 },
  { 1 },
  { 1 },
  { 2 },
  { 2 },
  { 3 },
  { 3 },
  { 4 }
};

#define nr_triangle_textures (sizeof triangle_textures / sizeof triangle_textures[0])

static struct { int tex; const char *name; } textures[] = {
  { 0, "images/craft1-under.jpg" },
  { 0, "images/craft1-back-side.jpg" },
  { 0, "images/craft1-side.jpg" },
  { 0, "images/craft1-inner-side.jpg" },
  { 0, "images/craft1-windscreen.jpg" }
};

#define nr_textures (sizeof textures / sizeof textures[0])

static void display_craft_n (int);

void
craft_init ()
{
  int i;

  log_assert (nr_triangles == nr_triangle_textures);

  for (i = 0; i < nr_textures; ++i)
    textures[i].tex = load_texture (textures[i].name);

  /* Scale vertices so that craft ranges from 0 to 1 along Z axis. */
  for (i = 0; i < nr_vertices; ++i)
    {
      vertices[i][0] = vertices[i][0] / 17;
      vertices[i][1] = vertices[i][1] / 17;
      vertices[i][2] = (vertices[i][2] + 6.666667) / 17;
    }
}

/* Display all craft. */
void
craft_display ()
{
  int cr,
    player_seg = pilot[local_player_nr].seg[1],
    ahead,
    lookahead = track->segments[player_seg].lookahead,
    craft_seg;

  if (player_in_view)
    display_craft_n (0);

  for (cr = 0; cr < MAX_PLAYERS; ++cr)
    {
      if (pilot[cr].pilot_type != PILOT_ROBOT
          && pilot[cr].pilot_type != PILOT_REMOTE)
	continue;

      /* Only display craft if in view. */
      craft_seg = pilot[cr].seg[1];
      if (player_seg < craft_seg)
	ahead = craft_seg - player_seg;
      else
	ahead = craft_seg + track->nr_segments - player_seg;
      if (ahead <= lookahead || ahead > track->nr_segments - 3)
	display_craft_n (cr);
    }
}

static void calculate_craft_ordinates (int cr, GLfloat *eye, GLfloat *cen, GLfloat *right, GLfloat *up);

static void
display_craft_n (int cr)
{
  int i;
  GLfloat v[nr_vertices][3], eye[3], fw[3], right[3], up[3];

  calculate_craft_ordinates (cr, eye, fw, right, up);

  /* Transform the vertices to their final positions. */
  for (i = 0; i < nr_vertices; ++i)
    {
      v[i][0] = eye[0] + (vertices[i][0] * right[0] + vertices[i][1] * up[0] + vertices[i][2] * fw[0]) * CRAFT_SCALE;
      v[i][1] = eye[1] + (vertices[i][0] * right[1] + vertices[i][1] * up[1] + vertices[i][2] * fw[1]) * CRAFT_SCALE;
      v[i][2] = eye[2] + (vertices[i][0] * right[2] + vertices[i][1] * up[2] + vertices[i][2] * fw[2]) * CRAFT_SCALE;
    }

  /* Draw the thing. */
  for (i = 0; i < nr_triangles; ++i)
    {
      glBindTexture (GL_TEXTURE_2D,
		     textures[triangle_textures[i].tex_index].tex);

      glBegin (GL_TRIANGLES);

      glTexCoord2f (triangles[i*3].r, triangles[i*3].s);
      glVertex3fv (v[triangles[i*3].v]);

      glTexCoord2f (triangles[i*3+1].r, triangles[i*3+1].s);
      glVertex3fv (v[triangles[i*3+1].v]);

      glTexCoord2f (triangles[i*3+2].r, triangles[i*3+2].s);
      glVertex3fv (v[triangles[i*3+2].v]);

      glEnd ();
    }
}

static void
calculate_craft_ordinates (int cr,
			   GLfloat *eye, GLfloat *fw,
			   GLfloat *back_line, GLfloat *up)
{
  GLfloat left_side[3];

  /* Midpoint of back line == eye position. */
  midpoint (pilot[cr].posn[1], pilot[cr].posn[2], eye);

  /* Midpoint to front point is forwards line. */
  fw[0] = pilot[cr].posn[0][0] - eye[0];
  fw[1] = pilot[cr].posn[0][1] - eye[1];
  fw[2] = pilot[cr].posn[0][2] - eye[2];
  normalize (fw, fw);

  /* Up is a vector at right angles to the back line and the
   * left and right sides. Use a cross product to calculate this.
   */
  back_line[0] = (pilot[cr].posn[2][0] - pilot[cr].posn[1][0]) / 2;
  back_line[1] = (pilot[cr].posn[2][1] - pilot[cr].posn[1][1]) / 2;
  back_line[2] = (pilot[cr].posn[2][2] - pilot[cr].posn[1][2]) / 2;
  left_side[0] = pilot[cr].posn[0][0] - pilot[cr].posn[1][0];
  left_side[1] = pilot[cr].posn[0][1] - pilot[cr].posn[1][1];
  left_side[2] = pilot[cr].posn[0][2] - pilot[cr].posn[1][2];
  cross_product (back_line, left_side, up);
  normalize (up, up);
  normalize (back_line, back_line);
}
