/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: display.c,v 1.37 1999/09/20 20:01:42 rich Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <fcntl.h>
#include <string.h>

#include "xracer.h"
#include "globals.h"
#include "cdmusic.h"
#include "keyboard.h"
#include "joystick.h"
#include "jpeg.h"
#include "os.h"

double current_time;
double start_time = 0.0;  /* Time at which the program started (for
                           * framerate calculation). */
double last_frame = 0.0;
double frame_time = 0.0;

int frame = 0;			/* Current frame. */

int wireframe = 0;		/* Wireframe mode. */
int segments = 0;		/* show segment number ? */
/* Controls. */
struct control control[8];

static void calculate_pilot_view (GLfloat *eye, GLfloat *cen, GLfloat *up);

void
recalc_time ()
{
  current_time = ws_get_time();

  if (start_time == 0.0) start_time = current_time;

  frame_time = current_time - last_frame;

  last_frame = current_time;
}

/* GLUT callback. */
void
reshape (int w, int h)
{
  log (LOG_DEBUG, "reshape (%d, %d)", w, h);
  width = w;
  height = h;

  textscale_x = (GLfloat)(width) / (GLfloat)(refwidth);
  textscale_y = (GLfloat)(height) / (GLfloat)(refheight);
  log(LOG_DEBUG, "textscale (%f, %f)", textscale_x, textscale_y);

  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluPerspective (50, (GLfloat) w / (GLfloat) h, 1, 1000);
}

/* GLUT callback. */
void
display ()
{
  GLenum error;
  static GLfloat ambient[4] = { 0.2, 0.2, 0.2, 0 };
  int i, s;
  GLfloat eye[3], cen[3], up[3];
  GLfloat saved_color[4];

  if (verbose) printf ("display: frame %d\n", frame);

  /* Recompute time. */
  recalc_time ();

#if 0
  log (LOG_DEBUG,
       "display (%g, %g, %g) (%g, %g, %g) (%g, %g, %g)",
       pilot.posn[0][0], pilot.posn[0][1], pilot.posn[0][2],
       pilot.posn[1][0], pilot.posn[1][1], pilot.posn[1][2],
       pilot.posn[2][0], pilot.posn[2][1], pilot.posn[2][2]);
#endif

  /* Clear the window. */
  if (wireframe) glClearColor(0, 0, 0, 0);
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  /* Move to pilot position. */
  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();
  calculate_pilot_view (eye, cen, up);
  gluLookAt (eye[0], eye[1], eye[2],
	     cen[0], cen[1], cen[2],
	     up[0],  up[1],  up[2]);

  /* Draw the view out of the window. */
  /*glShadeModel (GL_SMOOTH);*/
  glShadeModel (GL_FLAT);

  /* Determine differences between wireframe mode and non-wireframe mode */
  if (!wireframe)
    {
      glEnable (GL_TEXTURE_2D);
      glDepthMask(GL_FALSE);

      /* Draw the sky. */
      /* XXX Sky visibility test needed. */
      display_sky ();

      /* Draw the backdrop. */
      if (track->backdrop_tex > 0)
	{
	  glEnable (GL_BLEND);
	  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	  display_backdrop ();
	  glDisable (GL_BLEND);
	}

#if 0
      /* Cull back-facing polys in track. */
      glEnable (GL_CULL_FACE);
      glCullFace (GL_FRONT);
#endif

      glEnable (GL_DEPTH_TEST);
      glDepthMask(GL_TRUE);
      glEnable (GL_LIGHTING);
      glEnable (GL_LIGHT0);
      glLightfv (GL_LIGHT0, GL_POSITION, origin);
      glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE);
      glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient);

      /* Fog? */
      if (track->is_fog) glEnable (GL_FOG);
    }
  else /* Wireframe mode */
    {
      glDisable (GL_TEXTURE_2D);
      glShadeModel (GL_FLAT);
      glDepthMask(GL_FALSE);
      glDisable (GL_DEPTH_TEST);
      glDisable (GL_LIGHTING);
      glDisable(GL_FOG);

      /* Set wireframe polygon mode */
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

      /* Set the wireframe color for rendering the track */
      glColor4f(1.0, 0.0, 0.0, 1.0);
    }

  /* Draw the track. */
  for(i = -2; i < track->segments[pilot[local_player_nr].seg[1]].lookahead; ++i)
    {
      s = pilot[local_player_nr].seg[1] + i;
      if (s < 0) s += track->nr_segments;
      else if (s >= track->nr_segments) s -= track->nr_segments;
      glCallList (track->segments[s].dlist);
    }

  /* Set the wireframe scenery color */
  if (wireframe) glColor4f(0.0, 1.0, 0.0, 1.0);


  /* Draw scenery objects which are visible from here. */
  for(i = 0; i < track->segments[pilot[local_player_nr].seg[1]].nr_visible; ++i)
    {
      struct scenery *scenery
	= &track->scenery[track->segments[pilot[local_player_nr].seg[1]].visible[i]];
      int dlist = 0;

      if (scenery->is_start_lamp)
	{
	  switch (game_lamp_stage ())
	    {
	    case 1:
	    case 2:		/* Red lamp. */
	      dlist = track->scenery[scenery->u.animated.frame[0]].u.not_animated.dlist;
	      break;
	    case 3:		/* Yellow lamp. */
	      dlist = track->scenery[scenery->u.animated.frame[1]].u.not_animated.dlist;
	      break;
	    case 0:
	    case 4:		/* Green lamp. */
	      dlist = track->scenery[scenery->u.animated.frame[2]].u.not_animated.dlist;
	      break;
	    }
	}
      else if (scenery->is_animated)
	{
	  double t;
	  int j;

	  /* Work out which frame to display. */
	  t = (current_time / scenery->u.animated.total_ftime
	       - floor (current_time / scenery->u.animated.total_ftime))
	    * scenery->u.animated.total_ftime;
	  for (j = 0; j < scenery->u.animated.nr_frames-1; ++j)
	    {
	      if (t < scenery->u.animated.ftime[j])
		break;
	      t -= scenery->u.animated.ftime[j];
	    }

	  dlist = track->scenery[scenery->u.animated.frame[j]].u.not_animated.dlist;
	}
      else
	dlist = scenery->u.not_animated.dlist;

      glCallList (dlist);
    }

  /* Set the wireframe color for other craft */
  if (wireframe) glColor4f(0.0, 0.0, 1.0, 1.0);

  /* Draw the other craft. */
  craft_display ();

#if 0
  glDisable (GL_CULL_FACE);
#endif

  if (track->is_fog) glDisable (GL_FOG);

  glDisable (GL_TEXTURE_2D);
  glDisable (GL_LIGHT0);
  glDisable (GL_DEPTH_TEST);
  glShadeModel (GL_FLAT);
  glDisable (GL_LIGHTING);

  /* Switch to orthographic projection for static stuff on viewport. */
  glMatrixMode (GL_PROJECTION);
  glPushMatrix ();
  glLoadIdentity ();
  /*gluOrtho2D (0, (GLdouble) width, 0, (GLdouble) height);*/
  glOrtho (0, (GLdouble) width, 0, (GLdouble) height, 0, 1000);
  glMatrixMode (GL_MODELVIEW);
  glPushMatrix ();
  glLoadIdentity ();

  if (!wireframe)
    {
      /* Precipitation (rain or snow)? */
      if (track->is_precipitation)
	{
	  display_precipitation ();
	}

      /* Enable alpha blending. */
      glEnable (GL_BLEND);
      glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

      /* External shield? If so, draw a quad with a blue alpha colour
       * across the whole display.
       */
      if (pilot[local_player_nr].has_external_shield)
	{
	  glBegin (GL_QUADS);
	  glColor4f (0, 1, 1, 0.2);
	  glVertex2i (0, 0);
	  glVertex2i (0, height);
	  glVertex2i (width, height);
	  glVertex2i (width, 0);
	  glEnd ();
	}
    }
  else /* Wireframe mode */
    {
      glDisable(GL_BLEND);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);    
    }

  if (game.state == GAME_WAITING)
  {
    static int len = -1;
    static char text[] = "Waiting...";
    static void *font = 0;

    if (font == 0)
    {
      font = find_font("crillee", 36);
      log_assert(font != 0);
      len = get_text_width(font,text);
    }

    draw_text(font,text,(width - len) / 2, height * 2 / 3);
  }

  /* Autopilot? Display message. */
  if (pilot[local_player_nr].has_autopilot)
    {
      static int len = -1;
      static char text[] = "Autopilot activated";
      static void *font = 0;

      if (font == 0)
	{
	  font = find_font ("crillee", 36);
	  log_assert (font != 0);
	  len = get_text_width (font, text);
	}

      draw_text (font, text, (width - len) / 2, height * 2 / 3);
    }
  /*
   * bev 
   */
 	if(segments)
	{
		static int lseg = -1;
      		char textseg[12];
		static void *fontseg = 0;

      		if (fontseg == 0)
		{
	 	 fontseg = find_font ("crillee",14);
	  	 log_assert (fontseg != 0);
		}
	  	  
		 sprintf(textseg, "segs :%d",pilot[local_player_nr].greatest_segment );
		 lseg = get_text_width (fontseg, textseg);
		 draw_text (fontseg, textseg, 0 , 0);
	
	}
  /*
   * end bev
   */
  glGetFloatv(GL_CURRENT_COLOR,saved_color);

  /* Draw the instrument panel. */
  panel_display ();

  /* Draw the log messages. */
  log_display ();

  /* Game ended? Display rank, etc. over shaded background. */
  if (game_ended ())
    {
      glBegin (GL_QUADS);
      glColor4f (1, 1, 1, 0.5);
      glVertex2i (0, 0);
      glVertex2i (0, height);
      glVertex2i (width, height);
      glVertex2i (width, 0);
      glEnd ();

      display_game_over ();
    }

  glColor3fv(saved_color);

  glDisable (GL_BLEND);

  glMatrixMode (GL_MODELVIEW);
  glPopMatrix ();
  glMatrixMode (GL_PROJECTION);
  glPopMatrix ();

  /* Any errors? */
  error = glGetError ();
  if (error != GL_NO_ERROR)
    log (LOG_ERROR, "GL error: %s", gluErrorString (error));

  /* Flush commands out and tell GLUT to swap the double buffers. */
  glFlush ();
  glutSwapBuffers ();
  frame ++;

  /* We can't warp and grab the pointer until a few
   * frames have been displayed - it doesn't work
   * reliably otherwise on some X11 systems because
   * the window hasn't been mapped. So do it here.
   */
  if (frame == 3)
    {
      ws_warp_pointer ();
      ws_grab_pointer ();
    }

  /* Read joystick. */
  read_joystick ();

  /* Read keyboard. */
  read_keyboard ();

  /* Perform a screenshot if requested. */
  if (control[local_player_nr].screenshot)
  {
    take_screenshot();
    control[local_player_nr].screenshot = 0;
  }

  /* Update pilot position. */
  pilot_update ();
}

/* GLUT callback. */
void 
mouse (int button, int state, int x, int y)
{
  if (control[local_player_nr].mouse_flag)
    {
      if (!button && state == GLUT_DOWN)
        control[local_player_nr].accelerate
          = control[local_player_nr].mouse_accelerate = 1;
      else if (!button && state == GLUT_UP)
        control[local_player_nr].accelerate 
          = control[local_player_nr].mouse_accelerate = 0;
      if (button && state == GLUT_DOWN)
        control[local_player_nr].brake
          = control[local_player_nr].mouse_decelerate = 1;
      else if (button && state == GLUT_UP)
        control[local_player_nr].brake
          = control[local_player_nr].mouse_decelerate = 0;
    }
}

/* GLUT callback. */
void
mouse_motion (int x, int y)
{
  control[local_player_nr].mouse_x = 255 * x / width - 128;
  control[local_player_nr].mouse_y = 127 - 255 * y / height;
}

/* GLUT callback.
 * NB. Can't call this idle because it clashes with a
 * symbol in libc5. Thanks to "Nicolas S." <bobakitoo@yahoo.com>
 */
void
gidle ()
{
  glutPostRedisplay ();
}

/* Calculate coordinates for gluLookAt function. */
static void
calculate_pilot_view (GLfloat *eye, GLfloat *cen, GLfloat *up)
{
  GLfloat back_line[3], left_side[3];
  struct pilot *l_pilot;

  l_pilot = &pilot[local_player_nr];

  /* Midpoint of back line == eye position. */
  midpoint (l_pilot->posn[1], l_pilot->posn[2], eye);

  /* Front point == camera line. */
  memcpy (cen, l_pilot->posn[0], sizeof (GLfloat) * 3);

  /* Up is a vector at right angles to the back line and the
   * left and right sides. Use a cross product to calculate this.
   */
  back_line[0] = l_pilot->posn[2][0] - l_pilot->posn[1][0];
  back_line[1] = l_pilot->posn[2][1] - l_pilot->posn[1][1];
  back_line[2] = l_pilot->posn[2][2] - l_pilot->posn[1][2];
  left_side[0] = l_pilot->posn[0][0] - l_pilot->posn[1][0];
  left_side[1] = l_pilot->posn[0][1] - l_pilot->posn[1][1];
  left_side[2] = l_pilot->posn[0][2] - l_pilot->posn[1][2];
  cross_product (back_line, left_side, up);
}

/* Initialize controls. */
void
control_init ()
{
  memset (control, 0, sizeof control);
  control[local_player_nr].mouse_pitch = 1;
  control[local_player_nr].mouse_flag = 0;
  control[local_player_nr].mouse_sensitivity = 2;
}
