/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: linux.c,v 1.2 1999/07/21 07:47:40 rich Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <fcntl.h>

#include "xracer.h"
#include "joystick.h"

#include <linux/joystick.h>

/* File descriptor for the joystick. */
static int joy_fd = -1;

#define JOY_DEVICE "/dev/js0"

/* Detect and initialize the joystick.
   Returns zero if can not open device.
 */
void os_init_joystick()
{
  if ((joy_fd = open (JOY_DEVICE, O_RDONLY)) < 0)
    perror ("joystick (" JOY_DEVICE "): device not detected");
}

/* Read the current position of the joystick and button mode. */
void os_read_joystick()
{
  int status, x, y;
  size_t expected;
  struct JS_DATA_TYPE js;

  if (joy_fd == -1)
    return;

  status = read(joy_fd, &js, expected = JS_RETURN);

  if (status == expected)
  {
    x = js.x;
    y = js.y;

    if (x < 0) x = 0;
    else if (x > 255) x = 255;
    if (y < 0) y = 0;
    else if (y > 255) y = 255;

    /* So that (0,0) is joystick centre. */
    /* Someone said the range isn't 0-256, can't check since I have no 'stick */
    control[local_player_nr].joystick_x = x - 128; 
    control[local_player_nr].joystick_y = y - 128;

    control[local_player_nr].joystick_button1 = js.buttons & 1;
    control[local_player_nr].joystick_button2 = js.buttons & 2;
    control[local_player_nr].joystick_button3 = js.buttons & 4;
    control[local_player_nr].joystick_button4 = js.buttons & 8;
    control[local_player_nr].joystick_flag = 1;
  }
  else
  {
    log(LOG_INFO, "Unknown status from joystick: %d (ignored)", status);
    control[local_player_nr].joystick_flag = 0;
  }
}
