/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: load_track.c,v 1.5 1999/09/20 20:01:42 rich Exp $
 */

#include "xracer.h"
#include "sound.h"

static int fade_state;
static double fade_start;
static int next;

static int tex = 0;

static void
switch_to_start_game ()
{
  /* Initialize sky. */
  sky_init ();

  /* Initialize backdrop. */
  backdrop_init ();

  /* Initialize game. */
  game_init ();

  /* Start sound. */
  sound_enable ();

  /* Install GLUT handlers. */
  glutDisplayFunc (display);
  glutKeyboardFunc (keyboard);
  glutSpecialFunc (special);
  glutKeyboardUpFunc (keyboard_up);
  glutSpecialUpFunc (special_up);
  glutSetKeyRepeat (GLUT_KEY_REPEAT_OFF);
  glutPassiveMotionFunc(mouse_motion);
  glutMotionFunc(mouse_motion);
  glutMouseFunc (mouse);
  glutIdleFunc (gidle);
}

/* GLUT callback. */
static void
load_track_display ()
{
  recalc_time ();

  /* Clear the window. */
  glClear (GL_COLOR_BUFFER_BIT);

  /* Switch to orthographic projection. */
  glMatrixMode (GL_PROJECTION);
  glPushMatrix ();
  glLoadIdentity ();
  glOrtho (0, (GLdouble) width, 0, (GLdouble) height, 0, 1000);
  glMatrixMode (GL_MODELVIEW);
  glPushMatrix ();
  glLoadIdentity ();

  /* Draw the image. */
  glEnable (GL_TEXTURE_2D);
  glBindTexture (GL_TEXTURE_2D, tex);
  glBegin (GL_QUADS);
  glTexCoord2f (0, 0);
  glVertex2i (0, 0);
  glTexCoord2f (0, 1);
  glVertex2i (0, height);
  glTexCoord2f (1, 1);
  glVertex2i (width, height);
  glTexCoord2f (1, 0);
  glVertex2i (width, 0);
  glEnd ();
  glDisable (GL_TEXTURE_2D);

  /* Enable alpha blending. */
  glEnable (GL_BLEND);
  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  /* Fade effect. */
  if (do_menu_fade_effect (&fade_state, fade_start))
    switch_to_start_game ();

  glDisable (GL_BLEND);

  /* Restore matrices. */
  glMatrixMode (GL_MODELVIEW);
  glPopMatrix ();
  glMatrixMode (GL_PROJECTION);
  glPopMatrix ();

  glFlush ();
  glutSwapBuffers ();
}

static void
load_track_idle ()
{
  if (fade_state == 2)
    {
      if (track == 0 || current_track_name == 0 ||
	  strcmp (current_track_name, track_to_load) != 0)
	{
	  load_track (track_to_load);
	  current_track_name = track_to_load;
	}

      recalc_time ();
      fade_state = 1;		/* Start fading out. */
      fade_start = current_time;
    }

  glutPostRedisplay ();
}

static void
load_track_keyboard (unsigned char key, int x, int y)
{
  /* nothing */
}

/* Start loading the track. */
void
load_track_start ()
{
  recalc_time ();

  fade_state = 0;		/* Fade in. */
  fade_start = current_time;
  next = 0;

  /* Load the loading track image. */
  if (tex == 0)
    /* XXX Don't use load_texture_*. Build texture without mipmaps instead. */
    tex = load_texture ("images/xracer-logo-3.jpg");

  glutDisplayFunc (load_track_display);
  glutKeyboardFunc (load_track_keyboard);
  glutIdleFunc (load_track_idle);
}
