/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: menu.c,v 1.4 1999/09/20 20:01:42 rich Exp $
 */

#include "xracer.h"
#include "jpeg.h"

static int fade_state;
static double fade_start;
static int next;

static void
switch_to_next_menu ()
{
  switch (next)
    {
    case 1:
      load_track_start ();
      break;

    case 2:
      options_menu_start ();
      break;

    case 3:
      /*configuration_menu_start ();*/
      break;

    case 4:
      exit (0);

    default:
      log_assert (0);
    }
}

/* GLUT callback. */
static void
menu_display ()
{
  glClear (GL_COLOR_BUFFER_BIT);

  recalc_time ();

  /* Switch to orthographic projection. */
  glMatrixMode (GL_PROJECTION);
  glPushMatrix ();
  glLoadIdentity ();
  glOrtho (0, (GLdouble) width, 0, (GLdouble) height, 0, 1000);
  glMatrixMode (GL_MODELVIEW);
  glPushMatrix ();
  glLoadIdentity ();

  display_menu_image ();

  /* Enable alpha blending. */
  glEnable (GL_BLEND);
  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  /* Draw menu items. */
  menu_text_reset ();
  menu_text_print ("S"); menu_text_tab ();
  menu_text_print ("Start game"); menu_text_nl ();
  menu_text_print ("O"); menu_text_tab ();
  menu_text_print ("Game options"); menu_text_nl ();
  menu_text_print ("C"); menu_text_tab ();
  menu_text_print ("Game configuration"); menu_text_nl ();
  menu_text_print ("Q"); menu_text_tab ();
  menu_text_print ("Quit"); menu_text_nl ();

  /* Fade effect. */
  if (do_menu_fade_effect (&fade_state, fade_start))
    switch_to_next_menu ();

  glDisable (GL_BLEND);

  /* Restore matrices. */
  glMatrixMode (GL_MODELVIEW);
  glPopMatrix ();
  glMatrixMode (GL_PROJECTION);
  glPopMatrix ();

  glFlush ();
  glutSwapBuffers ();
}

/* GLUT callback. */
static void
menu_keyboard (unsigned char key, int x, int y)
{
  if (fade_state == 1) return;	/* Ignore keypresses while fading out. */

  switch (key)
    {
    case 's': case 'S':
      next = 1;
      fade_start = current_time;
      fade_state = 1;
      break;
    case 'o': case 'O':
      next = 2;
      fade_start = current_time;
      fade_state = 1;
      break;
    case 'c': case 'C':
      next = 3;
      fade_start = current_time;
      fade_state = 1;
      break;
    case 'q': case 'Q': case 27:
      next = 4;
      fade_start = current_time;
      fade_state = 1;
      break;
    }
}

/* Start displaying this menu. */
void
menu_start ()
{
  recalc_time ();
  fade_state = 0;		/* Fade in. */
  fade_start = current_time;
  next = 0;

  glutDisplayFunc (menu_display);
  glutKeyboardFunc (menu_keyboard);
  glutIdleFunc (gidle);
}

/* This is the background image shared by all menus. */
static int menu_tex = 0;

/* Display background menu image. */
void
display_menu_image ()
{
  if (menu_tex == 0)
    /* XXX Don't use load_texture_*. Build texture without mipmaps instead. */
    menu_tex = load_texture ("images/menus-bg.jpg");

  /* Draw the image. */
  glEnable (GL_TEXTURE_2D);
  glBindTexture (GL_TEXTURE_2D, menu_tex);
  glBegin (GL_QUADS);
  glTexCoord2f (0, 0);
  glVertex2i (0, 0);
  glTexCoord2f (0, 1);
  glVertex2i (0, height);
  glTexCoord2f (1, 1);
  glVertex2i (width, height);
  glTexCoord2f (1, 0);
  glVertex2i (width, 0);
  glEnd ();
  glDisable (GL_TEXTURE_2D);
}

/* Do the fade effect by applying an alpha'd quad over the
 * whole screen.
 */
#define TOTAL_FADE_TIME 1.0

int
do_menu_fade_effect (int *fade_state, double fade_start)
{
  GLfloat alpha;
  int r;

  if (*fade_state == 2) return 0;

  alpha = (current_time - fade_start) / TOTAL_FADE_TIME;
  if (alpha < 0) alpha = 0;
  else if (alpha > 1) alpha = 1;

  glBegin (GL_QUADS);
  glColor4f (0, 0, 0, *fade_state == 0 ? 1 - alpha : alpha);
  glVertex2i (0, 0);
  glVertex2i (0, height);
  glVertex2i (width, height);
  glVertex2i (width, 0);
  glEnd ();

  r = alpha == 1 && *fade_state == 1; /* Finished fading out. */

  if (alpha == 1) *fade_state = 2; /* Finished fading. */

  return r;
}

static void *font = 0;
static int x, y;
static int tab_width = -1, font_height = -1;

void
menu_text_reset ()
{
  if (font == 0)
    {
      font = find_font ("crillee", 36);
      if (font == 0) log_fatal ("can't find font crillee 36");
    }

  if (tab_width < 0)
    {
      tab_width = get_text_width (font, "        ");
    }

  if (font_height < 0)
    {
      font_height = get_text_height (font);
    }

  x = y = 0;
}

void
menu_text_print (const char *str)
{
  int rx, ry;

  /* Convert (x, y) to screen coordinates. */
  rx = x + 100;
  ry = 200 + y;

  /* Draw it. */
  draw_text (font, str, rx, ry);

  /* Advance the cursor. */
  x += get_text_width (font, str);
}

void
menu_text_tab ()
{
  x = (x / tab_width + 1) * tab_width;
}

void
menu_text_nl ()
{
  x = 0;
  y += font_height;
}
