/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: profile.c,v 1.1 1999/07/13 16:08:09 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "xracer.h"
#include "profile.h"

#if USE_PROFILE

unsigned long long profile_counter[NR_PROFILE_IDS][2];

static unsigned long long profile_start, profile_stop;
static void profile_stop_code (void);

void
profile_start_code ()
{
  profile_start = rdtsc ();
  atexit (profile_stop_code);
}

static void
profile_stop_code ()
{
  int i;
  static unsigned long long total_time;

  /* Finish any unclosed code sections. */
  for (i = 0; i < NR_PROFILE_IDS; ++i)
    {
      if (profile_counter[i][1] != 0)
	{
	  PROFILE_STOP (i);
	}
    }

  profile_stop = rdtsc ();

  /* Print total time. */
  printf ("Profiling report\n"
	  "----------------\n");
  printf ("total run time ...................... %Lu\n",
	  total_time = profile_stop - profile_start);

  for (i = 0; i < NR_PROFILE_IDS; ++i)
    {
      if (profile_counter[i][0] != 0)
	{
	  printf ("section %d: %Lu (%g %%)\n",
		  i,
		  profile_counter[i][0],
		  (double) profile_counter[i][0] / total_time);
	}
    }
}

#endif /* USE_PROFILE */
