/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: sky.c,v 1.8 1999/08/09 20:21:39 rich Exp $
 */

#include "xracer.h"

/* XXX We will eventually remove sky configurables out into
 * the track definition where they belong.
 */

static int sky_dlist;

void
sky_init ()
{
  /* XXX Don't use load_texture_*. Load it without building mipmaps instead. */
  int sky_tex = load_texture ("images/clouds2.jpg");

  sky_dlist = glGenLists (1);
  if (sky_dlist == 0)
    log_fatal ("glGenLists: cannot allocate display list: %s",
	       gluErrorString (glGetError ()));

  glNewList (sky_dlist, GL_COMPILE);

  glBindTexture (GL_TEXTURE_2D, sky_tex);

  glBegin (GL_QUAD_STRIP);
  glTexCoord2f (0, 1);
  glVertex3f (- 500, - 250, 20);
  glTexCoord2f (0, 0);
  glVertex3f (- 500, - 500, 20);

  glTexCoord2f (1, 1);
  glVertex3f (- 250, - 250, 40);
  glTexCoord2f (1, 0);
  glVertex3f (- 250, - 500, 20);

  glTexCoord2f (2, 1);
  glVertex3f (0, - 250, 40);
  glTexCoord2f (2, 0);
  glVertex3f (0, - 500, 20);

  glTexCoord2f (3, 1);
  glVertex3f (250, - 250, 40);
  glTexCoord2f (3, 0);
  glVertex3f (250, - 500, 20);

  glTexCoord2f (4, 1);
  glVertex3f (500, - 250, 20);
  glTexCoord2f (4, 0);
  glVertex3f (500, - 500, 20);
  glEnd ();

  glBegin (GL_QUAD_STRIP);
  glTexCoord2f (0, 2);
  glVertex3f (- 500, 0, 20);
  glTexCoord2f (0, 1);
  glVertex3f (- 500, - 250, 20);

  glTexCoord2f (1, 2);
  glVertex3f (- 250, 0, 40);
  glTexCoord2f (1, 1);
  glVertex3f (- 250, - 250, 40);

  glTexCoord2f (2, 2);
  glVertex3f (0, 0, 50);
  glTexCoord2f (2, 1);
  glVertex3f (0, - 250, 40);

  glTexCoord2f (3, 2);
  glVertex3f (250, 0, 40);
  glTexCoord2f (3, 1);
  glVertex3f (250, - 250, 40);

  glTexCoord2f (4, 2);
  glVertex3f (500, 0, 20);
  glTexCoord2f (4, 1);
  glVertex3f (500, - 250, 20);
  glEnd ();

  glBegin (GL_QUAD_STRIP);
  glTexCoord2f (0, 3);
  glVertex3f (- 500, 250, 20);
  glTexCoord2f (0, 2);
  glVertex3f (- 500, 0, 20);

  glTexCoord2f (1, 3);
  glVertex3f (- 250, 250, 40);
  glTexCoord2f (1, 2);
  glVertex3f (- 250, 0, 40);

  glTexCoord2f (2, 3);
  glVertex3f (0, 250, 40);
  glTexCoord2f (2, 2);
  glVertex3f (0, 0, 50);

  glTexCoord2f (3, 3);
  glVertex3f (250, 250, 40);
  glTexCoord2f (3, 2);
  glVertex3f (250, 0, 40);

  glTexCoord2f (4, 3);
  glVertex3f (500, 250, 20);
  glTexCoord2f (4, 2);
  glVertex3f (500, 0, 20);
  glEnd ();

  glBegin (GL_QUAD_STRIP);
  glTexCoord2f (0, 4);
  glVertex3f (- 500, 500, 20);
  glTexCoord2f (0, 3);
  glVertex3f (- 500, 250, 20);

  glTexCoord2f (1, 4);
  glVertex3f (- 250, 500, 20);
  glTexCoord2f (1, 3);
  glVertex3f (- 250, 250, 40);

  glTexCoord2f (2, 4);
  glVertex3f (0, 500, 20);
  glTexCoord2f (2, 3);
  glVertex3f (0, 250, 40);

  glTexCoord2f (3, 4);
  glVertex3f (250, 500, 20);
  glTexCoord2f (3, 3);
  glVertex3f (250, 250, 40);

  glTexCoord2f (4, 4);
  glVertex3f (500, 500, 20);
  glTexCoord2f (4, 3);
  glVertex3f (500, 250, 20);
  glEnd ();

  glEndList ();
}

void
display_sky ( /* float timeDelta */ )
/* timeDelta is the number of milliseconds since the last frame, 
 * used for animation.
 */
{
  static GLfloat cloud_posn = 0.0;
  GLfloat x = pilot[local_player_nr].posn[0][0];
  GLfloat y = pilot[local_player_nr].posn[0][1];
  GLfloat z = pilot[local_player_nr].posn[0][2];

  /* cloud_posn += 0.000002 * timeDelta; */
  cloud_posn += 0.0002;
  glMatrixMode( GL_TEXTURE );
  glPushMatrix();
  glLoadIdentity();
  glTranslatef( cloud_posn, cloud_posn, 0.0 );
  glMatrixMode( GL_MODELVIEW );
  glPushMatrix ();
  glTranslatef (x, y, z);

  glCallList (sky_dlist);

  glMatrixMode( GL_MODELVIEW );
  glPopMatrix ();
  glMatrixMode( GL_TEXTURE );
  glPopMatrix();
}
