/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: esd.c,v 1.3 1999/09/12 13:16:25 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <esd.h>

#include "xracer.h"
#include "os_sound.h"

static int esd_fd;
static int fd;
static int format = ESD_BITS16|ESD_STEREO|ESD_STREAM|ESD_PLAY;
static int rate = 44100;

int
os_sound_open_device ()
{
  if ((esd_fd = esd_open_sound ("127.0.0.1")) < 0)
    log_perror ("cannot open socket to ESD sound daemon - will revert to using /dev/dsp in blocking mode (which is probably not what you want)");

  fd = esd_play_stream_fallback (format, rate, 0, "NULL");

#if 0 /* No longer necessary, with new SIGIO method of handling pipe. */
  /* Put the socket into non-blocking mode. */
  if (fcntl (fd, F_SETFL, O_NONBLOCK) < 0)
    log_perror ("cannot set ESD socket to non-blocking mode (not fatal, but sound may be choppy)");
#endif

  return fd;
}

static void
close_everything ()
{
  /* XXX Does this close fd too? */
  esd_close (esd_fd);
}

int
os_sound_set_sample_rate (int sample_rate)
{
  rate = sample_rate;
  close_everything ();
  return os_sound_open_device ();
}

int
os_sound_set_nr_channels (int nr_channels)
{
  format &= ~ESD_MASK_CHAN;
  if (nr_channels == 1) format |= ESD_MONO; else format |= ESD_STEREO;
  close_everything ();
  return os_sound_open_device ();
}

int
os_sound_set_bits (int bits)
{
  format &= ~ESD_MASK_BITS;
  if (bits == 8) format |= ESD_BITS8; else format |= ESD_BITS16;
  close_everything ();
  return os_sound_open_device ();
}

int
os_sound_write (void *buffer, int size)
{
  int n;

  while (size > 0)
    {
      n = write (fd, buffer, size);

      if (n < 0)
	{
	  perror ("write");
	  return -1;
	}

      size -= n;
      buffer += n;
    }
  return fd;
}

int
os_sound_enable ()
{
  return fd;
}

int
os_sound_disable ()
{
  return fd;
}
