/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: linux.c,v 1.8 1999/09/12 13:16:25 rich Exp $
 */

/* This code is derived from the source to SOX,
 * Copyright (C) 1997 Chris Bagwell (cbagwell@sprynet.com) and others.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>

#include "xracer.h"
#include "os_sound.h"

static int fd;

int
os_sound_open_device ()
{
  int buf_flags;

  fd = open ("/dev/dsp", O_WRONLY);
  if (fd < 0) { perror ("/dev/dsp"); return -1; }
  buf_flags = 0x00020008;	/* 2 buffers, 16K each buffer. */
  if (ioctl (fd, SNDCTL_DSP_SETFRAGMENT, &buf_flags) == -1)
    {
      log_perror ("SNDCTL_DSP_SETFRAGMENT");
      goto error;
    }
  if (ioctl(fd, SNDCTL_DSP_RESET, 0) < 0)
    {
      log_perror ("SNDCTL_DSP_RESET");
      goto error;
    }

  return fd;

 error:
  close (fd);
  return -1;
}

int
os_sound_set_sample_rate (int sample_rate)
{
  int t = sample_rate;

  if (ioctl (fd, SNDCTL_DSP_SPEED, &t) < 0
      || t != sample_rate)
    {
      perror ("SNDCTL_DSP_SPEED");
      return -1;
    }
  return fd;
}

int
os_sound_set_nr_channels (int nr_channels)
{
  int stereo = nr_channels - 1;
  int t = stereo;

  if (ioctl (fd, SNDCTL_DSP_STEREO, &t) < 0
      || t != stereo)
    {
      perror ("SNDCTL_DSP_STEREO");
      return -1;
    }
  return fd;
}

int
os_sound_set_bits (int bits)
{
  int t = bits;

  if (ioctl (fd, SNDCTL_DSP_SETFMT, &t) < 0
      || t != bits)
    {
      perror ("SNDCTL_DSP_SETFMT");
      return -1;
    }
  return fd;
}

int
os_sound_write (void *buffer, int size)
{
  int n;

  while (size > 0)
    {
      n = write (fd, buffer, size);

      if (n < 0)
	{
	  perror ("write");
	  return -1;
	}

      size -= n;
      buffer += n;
    }
  return fd;
}

int
os_sound_enable ()
{
  return fd;
}

int
os_sound_disable ()
{
  return fd;
}
