/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: x11.c,v 1.1 1999/07/21 07:39:43 rich Exp $
 */

#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xracer.h"
#include "os.h"

double ws_get_time()
{
  struct timeval tv;

  gettimeofday(&tv,0);

  return (double)tv.tv_sec + (double)tv.tv_usec * 1e-6;
}

/* X11- and GLUT-specific hack to warp and grab the pointer into the window. */

struct GLUTwindow
{
  int num;
  Window win;
};

extern Display *__glutDisplay;

extern Window __glutRoot;
extern struct GLUTwindow *__glutCurrentWindow;

void ws_warp_pointer()
{
  Window window = __glutCurrentWindow->win;

  XWarpPointer(__glutDisplay, 0, window, 0, 0, 0, 0, width/2, height/2);
}

/* Grab the pointer. */

void ws_grab_pointer()
{
  Window window = __glutCurrentWindow->win;

  if (XGrabPointer(__glutDisplay, window, True,
        ButtonReleaseMask | ButtonPressMask,
        GrabModeAsync, GrabModeAsync,
        window, None, CurrentTime) != GrabSuccess)
    log (LOG_ERROR, "pointer grab failed");
}

void ws_flush_events()
{
  XSync(__glutDisplay, False);
}

/* X11 hack to give window a class, so WindowManagers can interact with it
   (e.g. start xracer without window borders/titlebar, start fullscreen,...)
   Why isn't this implemented in glutCreateWindow? */

void ws_fix_window()
{
   XClassHint classhint;
   Window window = __glutCurrentWindow->win;

   classhint.res_name="xracer";
   classhint.res_class="XRacer";
   XSetClassHint(__glutDisplay, window, &classhint);
}
