#ifndef __xracer_net_h__
#define __xracer_net_h__

#include "xracer.h"

#define XRACER_PORT 4242
#define MAX_NET_MESSAGE_LEN 60
#define MAX_NAME_LEN 8
#define PACKET_INTERVAL 0.01

/* Packet types */
#define PACKET_JOIN_REQUEST  0x00
#define PACKET_JOIN_ACCEPT   0x01
#define PACKET_PLAYER_LIST   0x02
#define PACKET_BEGIN_GAME    0x03

struct packet_join_request
{
  char player_name[MAX_NAME_LEN+1]; /* Client player name */
  unsigned short udp_port;          /* UDP port on clientside */
};

struct packet_join_accept
{
  char server_motd[MAX_NET_MESSAGE_LEN+1]; /* Server MOTD */
  unsigned char playernum;                 /* Player number for this player */
};

struct packet_player_list
{
  char player_names[MAX_PLAYERS][MAX_NAME_LEN+1]; /* Player name list */
};

struct packet_position_data
{
  unsigned char playernum; /* Whose positiondata this is */
  float pos[3][3];
  float roll,pitch,yaw;
};

struct packet_begin_game
{
  int dummy;
};

void net_init(void);
void net_run(void);
void net_begin_game(void);

#endif
