/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: backdrop.c,v 1.3 1999/07/31 16:09:20 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "xracer.h"
#include "matrix.h"

/* The backdrop is modelled as a cylinder which surrounds the
 * craft at a fixed distance. We initialize a display list
 * describing this cylinder around the craft, and then each
 * frame use the model view to transform it around the craft.
 * This is not very efficient, because we end up always
 * drawing the entire backdrop (XXX).
 */

#define BACKDROP_TOP 5
#define BACKDROP_BASE -5
#define BACKDROP_NR_SECTS 20
#define BACKDROP_RADIUS 10

static int dlist;

void
backdrop_init ()
{
  int i;
  GLfloat t;
  GLfloat a;

  dlist = glGenLists (1);
  if (dlist == 0)
    log_fatal ("glGenLists: cannot allocate display list: %s",
	       gluErrorString (glGetError ()));

  glNewList (dlist, GL_COMPILE);

  glBindTexture (GL_TEXTURE_2D, track->backdrop_tex);
  glBegin (GL_QUAD_STRIP);

  for (i = 0; i <= BACKDROP_NR_SECTS; ++i)
    {
      t = (GLfloat) i / BACKDROP_NR_SECTS; /* Parameter from 0 to 1. */
      a = 2 * M_PI * t;		/* Angle from 0 to 2*pi. */

      glTexCoord2f (t * track->backdrop_x_scale, 0);
      glVertex3f (BACKDROP_RADIUS * cos (a), BACKDROP_RADIUS * sin (a),
		  BACKDROP_BASE);
      glTexCoord2f (t * track->backdrop_x_scale, 1);
      glVertex3f (BACKDROP_RADIUS * cos (a), BACKDROP_RADIUS * sin (a),
		  BACKDROP_TOP);
    }

  glEnd ();
  glEndList ();
}

void
display_backdrop ()
{
  glMatrixMode (GL_MODELVIEW);
  glPushMatrix ();
  glTranslatef (pilot[local_player_nr].posn[0][0],
		pilot[local_player_nr].posn[0][1],
		pilot[local_player_nr].posn[0][2]);
  glCallList (dlist);
  glPopMatrix ();
}
