/* cdmusic (c) y2k-186  Yousry(u3) Abdallah */

#include <fcntl.h>
#include <unistd.h>

#ifdef linux
#include <sys/ioctl.h>
#include <linux/cdrom.h>
#endif

#include "cdmusic.h"

static int fd = -1;
static int trigger = 0;

#ifdef linux
static struct cdrom_tochdr status;
static struct cdrom_ti playlist;
#endif

int
open_cd ()
{
#ifdef linux
  fd=open("/dev/cdrom", O_RDONLY | O_NONBLOCK);
  if(fd == -1)
    return 0; /* CD Audio not available */
  return 1; /* Audio CD found */
#else
  return 0;
#endif
}

void
close_cd ()
{
#ifdef linux
  if(fd == -1)
    return;
  ioctl(fd,CDROMSTOP);	
  close(fd);
#endif
}

void
play_cd ()
{
#ifdef linux
  if(fd == -1 && !open_cd())
    return;
  ioctl(fd, CDROMREADTOCHDR, &status);
  playlist.cdti_ind0 = playlist.cdti_ind1 =0;
  playlist.cdti_trk0 = status.cdth_trk0;
  playlist.cdti_trk1 = status.cdth_trk1;
  ioctl(fd, CDROMPLAYTRKIND, &playlist);
#endif
}		

void
stop_cd (){
#ifdef linux
  if(fd == -1)
    return;
  ioctl(fd, CDROMSTOP);
#endif
}
	
void
skip_cd (){
#ifdef linux
  if (fd >= 0)
    {
      ioctl(fd, CDROMSTOP);
      if (++playlist.cdti_trk0 > status.cdth_trk1)
	playlist.cdti_trk0 = status.cdth_trk0;
      ioctl(fd, CDROMPLAYTRKIND, &playlist);
    }
#endif
}

void
pause_cd (){
#ifdef linux
  if(fd == -1)
    return;
  if(!trigger) {
    ioctl(fd,CDROMPAUSE);
    trigger = 1;
  } else {		
    ioctl(fd,CDROMRESUME);
    trigger = 0;
  }	
#endif
}
