/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: init.c,v 1.15 1999/09/20 20:01:42 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#if HAVE_GETOPT_H
#include <getopt.h>
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "xracer.h"
#include "globals.h"

static int
str_end_cmp( char* s , char* extension );

int
check_args(int argc, char* argv[])
{
  int c;
#if HAVE_GETOPT_LONG
  int option_index = 0;
  struct option long_options[] =
  {
    {"arcade",          no_argument,       0, 'a'},
    {"fullscreen",      no_argument,       0, 'f'},
    {"help",            no_argument,       0, 'h'},
    {"size",            required_argument, 0, 's'},
    {"trial",           no_argument,       0, 't'},
    {"version",         no_argument,       0, 'V'},
    {"verbose",         no_argument,       0, 'v'},
    {"laps",		required_argument, 0, 'l'},
    {"difficulty",	required_argument, 0, 'd'},
    {"net-server",      no_argument,       0, 'N'},
    {"net-client",      required_argument, 0, 'n'},
    {"name",            required_argument, 0, 'p'},
    {"server-motd",     required_argument, 0, 'm'},
    {"map",		required_argument, 0, 'M'},
    {"nosound",         no_argument,       0, 'q'},
    {"nomipmap",        no_argument,       0, 'L'},
    {0, 0, 0, 0}
  };
#endif

#define ARG_STRING "afhs:tVvl:d:Nn:p:m:M:qL"

  while ((c =
#if HAVE_GETOPT_LONG
	  getopt_long (argc, argv, ARG_STRING, long_options, &option_index)
#elif HAVE_GETOPT
	  getopt (argc, argv, ARG_STRING)
#else
#error "requires getopt or getopt_long calls"
#endif
	  ) != -1)
    {
      switch (c)
	{
	case 'a':
	  mode = ARCADE_MODE;
	  break;
	case 'f':
	  fullscreen = 1;
	  break;
	case 'V':
	  printf("%s %s\n", PACKAGE, VERSION);
	  exit(EXIT_SUCCESS);
	  break;
	case 'v':
	  ++verbose;
	  break;
	case 's':
	  if (sscanf (optarg, "%dx%d", &width, &height) != 2)
	    {
	      fprintf (stderr,
		       "xracer: don't understand size argument %s (expect WIDTHxHEIGHT)\n", optarg);
	      exit (1);
	    }
	  break;
	case 'l':
	  if (sscanf (optarg, "%d", &game.nr_laps) != 1)
	    {
	      fprintf (stderr,
		       "xracer: don't understand laps argument %s (expect nLAPS)\n", optarg);
	      exit (1);
	    }
	  break;

	case 'd':
	  if (sscanf (optarg, "%d", &difficulty) != 1)
	    {
	      fprintf (stderr,
		       "xracer: don't understand difficulty argument %s (expect 0,1 or 2)\n", optarg);
	      exit (1);
	    } else {

	    	if ( (difficulty != EASY) && ( difficulty != MEDIUM ) && ( difficulty != HARD ) )
		{	
			difficulty = MEDIUM;
			fprintf (stderr, "xracer: unkown difficulty level\n"); 
		}	
	    }
	  break;

	case 't':
	  mode = TIME_TRIAL_MODE;
	  break;
  case 'N':
    mode = NETGAME_MODE;
    netserver = NULL;
    break;
  case 'n':
    mode = NETGAME_MODE;
    netserver = xstrdup(optarg);
    break;
  case 'p':
    plr_name = xstrdup(optarg);
    break;
  case 'm':
    netservermotd = xstrdup(optarg);
    break;
  
  case 'M':
    if (str_end_cmp (optarg, ".trk.gz"))
      {
	track_to_load = (char*)xmalloc (strlen(optarg)+7);
	sprintf(track_to_load, "tracks/%s", optarg );
	     
      }
    else
      {
	track_to_load = (char*)xmalloc (strlen(optarg)+14);
	sprintf(track_to_load, "tracks/%s.trk.gz", optarg);
      }
    break;

  case 'q':
    nosound = 1;
    break;

  case 'L':
    mipmapping = 0;
    break;

   
	default:
	  fprintf (stderr,
		   "Usage: xracer [OPTIONS]...\n"
		   "  -a, --arcade                Arcade mode (default).\n"
		   "  -f, --fullscreen            Force fullscreen mode.\n"
		   "  -s, --size    WIDTHxHEIGHT  Set screen size (eg. 640x480).\n"
		   "  -t, --trial                 Time trial mode.\n"
		   "  -v, --verbose               Print more verbose messages\n"
		   "  -V, --version               Output version information and exit\n"
		   "  -l, --laps    LAPS          Select number of laps (default 3)\n"
		   "  -d, --difficulty  LEVEL     Select difficulty level [0-2] (default 1)\n"
		   "  -M, --map  FILE		  Specify the track to load (eg \"demo\")\n"
       "  -q, --nosound               Disable sound\n"
       "  -L, --nomipmap              Disable MIP-mapping (faster, but less accurate display)\n"
		   );
	  exit (1);
	}
    }

  if (!plr_name)
    plr_name = getenv("LOGNAME");
    
  return 1;
}

static int
str_end_cmp( char* s , char* extension )
{
	int ls, le;
	ls = strlen(s);
	le = strlen(extension);
	
	if ( ls < le )
		return 0;
	if ( !strcmp(extension, (char*)(s+(ls-le))) )
	{
		printf("match\n");
		return 1;
	}
	return 0;
}

