/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: keyboard.c,v 1.13 1999/08/08 15:37:37 rich Exp $
 *
 * This file was written by Eden Li <tile@primenet.com> 1999/07/03.
 * Only a preliminary version of keyboard configuration
 *
 * Rewritten by RWMJ 1999/07/11. There are now separate
 * handlers for event_start and event_stop, and a concept
 * of one-shot keyboard events. One of the casualties in
 * this was the keyboard configuration file, but I'm planning
 * on unifying configuration using a different mechanism
 * later, so that would have gone anyway sooner or later.
 */

#include <stdio.h>
#include <limits.h>
#include <string.h>

#include "xracer.h"
#include "keyboard.h"
#include "cdmusic.h"

static int accelerate = 0, brake = 0, left = 0, right = 0, up = 0, down = 0;

/* An event handler structure. */
struct event_handler
{
  void (*start) (void);		/* Start of event (ie. key press). */
  void (*stop) (void);		/* End of event (ie. key release). */
};

/* Convenient macros to set these handlers up. */
#define ONE_SHOT(name) struct event_handler name##_handler = { name, 0 }
#define CONTINUOUS(name) struct event_handler name##_handler = { name##_start, name##_stop }

/* This table maps keyboard keycodes to event handlers. */
struct event_handler keyboard_table [UCHAR_MAX];

/* This table maps special keycodes to event handlers. */
struct event_handler special_table [UCHAR_MAX];

/* The actual event handlers. */
static void
screen_shot ()
{
  control[local_player_nr].screenshot = 1;
}

ONE_SHOT (screen_shot);

static void
restart ()
{
  pilot_init ();
  /* game_trigger_start (); */
}

ONE_SHOT (restart);

static void
next_cd_track ()
{
  skip_cd ();
}

ONE_SHOT (next_cd_track);

static void
invert_mouse ()
{
  control[local_player_nr].mouse_pitch *= -1;
}

ONE_SHOT (invert_mouse);

static void
enable_mouse ()
{
  control[local_player_nr].mouse_flag = !control[local_player_nr].mouse_flag;
}

ONE_SHOT (enable_mouse);

static void
mouse_sensitivity_up ()
{
  control[local_player_nr].mouse_sensitivity *= 2;
}

ONE_SHOT (mouse_sensitivity_up);

static void
mouse_sensitivity_down ()
{
  control[local_player_nr].mouse_sensitivity /= 2;
}

ONE_SHOT (mouse_sensitivity_down);

static void
quit ()
{
  exit (0);
}

ONE_SHOT (quit);

static void
show_fps ()
{
  control[local_player_nr].show_fps ^= 1;
}

ONE_SHOT (show_fps);

static void
faster_start ()
{
  accelerate = 1;
}

static void
faster_stop ()
{
  accelerate = 0;
}

CONTINUOUS (faster);

static void
slower_start ()
{
  brake = 1;
}

static void
slower_stop ()
{
  brake = 0;
}

CONTINUOUS (slower);

static void
left_start ()
{
  left = 1;
}

static void
left_stop ()
{
  left = 0;
}

CONTINUOUS (left);

static void
right_start ()
{
  right = 1;
}

static void
right_stop ()
{
  right = 0;
}

CONTINUOUS (right);

static void
up_start ()
{
  up = 1;
}

static void
up_stop ()
{
  up = 0;
}

CONTINUOUS (up);

static void
down_start ()
{
  down = 1;
}

static void
down_stop ()
{
  down = 0;
}

CONTINUOUS (down);

static void
fire ()
{
  game_fire (local_player_nr);
}

ONE_SHOT (fire);

static void
toggle_wireframe ()
{
  wireframe = !wireframe;
}
ONE_SHOT (toggle_wireframe);

static void
toggle_segments ()
{
  segments = !segments;
}

ONE_SHOT(toggle_segments);

ONE_SHOT(game_begin);

void
keyboard_init ()
{
  memset (keyboard_table, 0, sizeof keyboard_table);
  memset (special_table, 0, sizeof special_table);

  /* Initialize a few standard event handlers. */
  keyboard_table['s'] = screen_shot_handler;
  keyboard_table['r'] = restart_handler;
  keyboard_table['y'] = next_cd_track_handler;
  keyboard_table['n'] = invert_mouse_handler;
  keyboard_table['d'] = enable_mouse_handler;
  keyboard_table['e'] = mouse_sensitivity_down_handler;
  keyboard_table['w'] = mouse_sensitivity_up_handler;
  keyboard_table['q'] = quit_handler;
  keyboard_table[27]  = quit_handler;
  keyboard_table['f'] = show_fps_handler;
  keyboard_table[' '] = fire_handler;
  keyboard_table['l'] = toggle_wireframe_handler;
  keyboard_table['g'] = game_begin_handler;
  keyboard_table['a'] = toggle_segments_handler;

  /* Initialize a few special event handlers. */
  special_table[GLUT_KEY_LEFT] = left_handler;
  special_table[GLUT_KEY_RIGHT] = right_handler;
  special_table[GLUT_KEY_UP] = up_handler;
  special_table[GLUT_KEY_DOWN] = down_handler;
  special_table[GLUT_KEY_PAGE_UP] = faster_handler;
  special_table[GLUT_KEY_PAGE_DOWN] = slower_handler;
}

void
read_keyboard ()
{
  /* Interpret the state of the left, right, up, down keys. */
  if (left == 1 && right == 0)
    {
      control[local_player_nr].keyboard_x -= 4;
      if (control[local_player_nr].keyboard_x < -128)
        control[local_player_nr].keyboard_x = -128;
    }
  else if (left == 0 && right == 1)
    {
      control[local_player_nr].keyboard_x += 4;
      if (control[local_player_nr].keyboard_x > 127)
        control[local_player_nr].keyboard_x = 127;
    }
  else
    {
      control[local_player_nr].keyboard_x = 
        control[local_player_nr].keyboard_x * 2 / 3;
    }

  if (down == 1 && up == 0)
    {
      control[local_player_nr].keyboard_y += 4;
      if (control[local_player_nr].keyboard_y > 127)
        control[local_player_nr].keyboard_y = 127;
    }
  else if (down == 0 && up == 1)
    {
      control[local_player_nr].keyboard_y -= 4;
      if (control[local_player_nr].keyboard_y < -128)
        control[local_player_nr].keyboard_y = -128;
    }
  else
    {
      control[local_player_nr].keyboard_y =
        control[local_player_nr].keyboard_y * 2 / 3;
    }

  if (control[local_player_nr].keyboard_x != 0
      || control[local_player_nr].keyboard_y != 0)
    control[local_player_nr].keyboard_flag = 1;

  if (accelerate) control[local_player_nr].accelerate = 1;
  if (brake)      control[local_player_nr].brake = 1;
}

void
keyboard (unsigned char key, int x, int y)
{
  if (keyboard_table[key].start)
    (keyboard_table[key].start) ();
}

void
keyboard_up (unsigned char key, int x, int y)
{
  if (keyboard_table[key].stop)
    (keyboard_table[key].stop) ();
}

void
special (int key, int x, int y)
{
  log_assert (key < UCHAR_MAX);

  if (special_table[key].start)
    (special_table[key].start) ();
}

void
special_up (int key, int x, int y)
{
  log_assert (key < UCHAR_MAX);

  if (special_table[key].stop)
    (special_table[key].stop) ();
}
