/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: options_menu.c,v 1.1 1999/08/08 15:37:37 rich Exp $
 */

#include "xracer.h"

static int fade_state;
static double fade_start;

/* GLUT callback. */
static void
options_menu_display ()
{
  glClear (GL_COLOR_BUFFER_BIT);

  recalc_time ();

  /* Switch to orthographic projection. */
  glMatrixMode (GL_PROJECTION);
  glPushMatrix ();
  glLoadIdentity ();
  glOrtho (0, (GLdouble) width, 0, (GLdouble) height, 0, 1000);
  glMatrixMode (GL_MODELVIEW);
  glPushMatrix ();
  glLoadIdentity ();

  display_menu_image ();

  /* Enable alpha blending. */
  glEnable (GL_BLEND);
  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  /* Draw menu items. */
  menu_text_reset ();
  menu_text_print ("M"); menu_text_tab ();
  menu_text_print ("Mode: ");
  switch (mode)
    {
    case ARCADE_MODE: menu_text_print ("Arcade"); break;
    case TIME_TRIAL_MODE: menu_text_print ("Time Trials"); break;
    case NETGAME_MODE: menu_text_print ("Networked Game"); break;
    }
  menu_text_nl ();
  menu_text_print ("Esc"); menu_text_tab ();
  menu_text_print ("Return to main menu");

  /* Fade effect. */
  if (do_menu_fade_effect (&fade_state, fade_start))
    menu_start ();

  glDisable (GL_BLEND);

  /* Restore matrices. */
  glMatrixMode (GL_MODELVIEW);
  glPopMatrix ();
  glMatrixMode (GL_PROJECTION);
  glPopMatrix ();

  glFlush ();
  glutSwapBuffers ();
}

/* GLUT callback. */
static void
options_menu_keyboard (unsigned char key, int x, int y)
{
  if (fade_state == 1) return;	/* Ignore keypresses while fading out. */

  switch (key)
    {
    case 'm': case 'M':
      if (mode == ARCADE_MODE) mode = TIME_TRIAL_MODE;
      else if (mode == TIME_TRIAL_MODE) mode = ARCADE_MODE;
      break;
    case 27:
      fade_start = current_time;
      fade_state = 1;
      break;
    }
}

/* Start displaying this menu. */
void
options_menu_start ()
{
  fade_state = 0;		/* Fade in. */
  fade_start = current_time;

  glutDisplayFunc (options_menu_display);
  glutKeyboardFunc (options_menu_keyboard);
}
