/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: profile.h,v 1.1 1999/07/13 16:08:09 rich Exp $
 */

/* This file defines some code for automatically profiling
 * short code sections. To instrument the code, firstly
 * add PROFILE_START_CODE somewhere where it will be called
 * at the beginning of the code, and then add:
 *
 * PROFILE_START(id)
 *   ...
 * PROFILE_STOP(id)
 *
 * around the pieces of code which need to be profiled.
 * The id argument should be a number between 0 and NR_PROFILE_IDS-1
 * identifying each code segment uniquely. When the program
 * exits, the time spent in the code as a while and the
 * proportions spent in each code section will be displayed.
 *
 * It relies on having a fast and accurate counter, and for
 * this we use the Pentium TSC. Therefore this code won't
 * work on non-Intel architectures without substituting
 * something else for this opcode.
 */

#ifndef __profile_h__
#define __profile_h__

#ifndef NR_PROFILE_IDS
#define NR_PROFILE_IDS 256
#endif

#if USE_PROFILE

#include "rdtsc.h"

extern unsigned long long profile_counter[NR_PROFILE_IDS][2];
extern void profile_start_code (void);

#define PROFILE_START_CODE profile_start_code ()
#define PROFILE_START(id) do { log_assert (profile_counter[(id)][1] == 0); profile_counter[(id)][1] = rdtsc (); } while (0)
#define PROFILE_STOP(id) do { log_assert (profile_counter[(id)][1] != 0); profile_counter[(id)][0] += rdtsc () - profile_counter[(id)][1]; profile_counter[(id)][1] = 0; } while (0)

#else /* ! USE_PROFILE */

#define PROFILE_START_CODE
#define PROFILE_START(id)
#define PROFILE_STOP(id)

#endif /* ! USE_PROFILE */

#endif /* __profile_h__ */
