/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: screenshot.c,v 1.3 1999/07/06 23:01:27 rich Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/param.h>

#include "xracer.h"

/* This is a hack for non-POSIX Sun and SGI. */
#if !defined(PATH_MAX)
#define PATH_MAX 10000
#endif

static const char *
random_string ()
{
  static char str[9] = { 0, 0, 0, 0, 0, 0, 0, 0, 0 };
  static const char *ch = "abcdefghijklmnopqrstuvwxyz0123456789";
  int i;
  long t = (current_time - start_time) * 1000;

  for (i = 0; i < 8; ++i)
    {
      str[7-i] = ch[t&31];
      t >>= 5;
    }

  return str;
}

void
take_screenshot ()
{
  char pathname [PATH_MAX];
  FILE *fp;
  char *pixels;
  int y;

  /* Generate a suitable random filename. */
  sprintf (pathname, "/tmp/xracer-%s.ppm", random_string ());

  /* Open the file, write the header. */
  if ((fp = fopen (pathname, "w")) == 0)
    {
      log_perror (pathname);
      return;
    }

  fprintf (fp, "P6 %d %d 255\n", width, height);

  /* Capture the screen into a buffer. */
  pixels = xmalloc (width * height * 3);
  glReadPixels (0, 0, width, height, GL_RGB, GL_UNSIGNED_BYTE, pixels);

  /* Write the pixels out to a file (remember GL saves them upside down). */
  for (y = 0; y < height; ++y)
    {
      int len = width * 3;
      int start = len * (height - y - 1);

      if (fwrite (pixels + start, len, 1, fp) < 1)
	{
	  log_perror ("write: %s", pathname);
	  free (pixels);
	  fclose (fp);
	  unlink (pathname);
	  return;
	}
    }

  free (pixels);
  log (LOG_INFO, "Saved screenshot to file %s", pathname);
}
