/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: sound.h,v 1.2 1999/07/27 22:50:59 rich Exp $
 */

#ifndef __sound_h__
#define __sound_h__

extern void sound_init (int init_sample_rate,
			int init_nr_channels,
			int init_bits);
extern void sound_enable ();
extern void sound_disable ();
extern void sound_set_sample_rate (int _sample_rate);
extern int sound_get_sample_rate ();
extern void sound_set_nr_channels (int _nr_channels);
extern int sound_get_nr_channels ();
extern void sound_set_bits (int _bits);
extern int sound_get_bits ();
extern void sound_set_mixer_wind_noise_amplitude (float _wind_noise_amplitude);
extern float sound_get_mixer_wind_noise_amplitude ();
extern void sound_set_mixer_echo_amplitude (float _echo_amplitude);
extern float sound_get_mixer_echo_amplitude ();
extern void sound_set_mixer_output_amplitude (float _output_amplitude);
extern float sound_get_mixer_output_amplitude ();
extern void sound_set_echo_delay (float _delay);
extern float sound_get_echo_delay ();
extern void sound_set_echo_level (float _level);
extern float sound_get_echo_level ();
extern void sound_set_craft_velocity (float _craft_velocity);
extern float sound_get_craft_velocity ();
extern void sound_play_sample (int sample_num);

extern int sound_state;

#define SOUND_STATE_DISABLED 0	/* Disabled. */
#define SOUND_STATE_ENABLED  1	/* Enabled. */
#define SOUND_STATE_DEAD     2	/* Dead: fatal error, sound cannot be
				 * reenabled.
				 */

#endif /* __sound_h__ */
