/* XRacer (C) 1999 Richard W.M. Jones.
 * $Id: sound_process.h,v 1.4 1999/09/12 13:16:24 rich Exp $
 */

/* This is the interface between the sound subsystem in
 * XRacer and the child sound process. Do not use it
 * directly or include it anywhere else.
 */

#ifndef __sound_process_h__
#define __sound_process_h__

#include "xracer.h"

#if SOUND_USE_FORK
#define SOUND_SHM_MAX_REQUESTS 1024
#endif

/* Format of requests sent over pipe. */
struct sound_request {
  int type;			/* Request type - see below. */
  union {
    float f;			/* Use these for simple requests. */
    int i;
  } u;
};

#define SOUND_REQUEST_ENABLE          1000
#define SOUND_REQUEST_DISABLE         1001
#define SOUND_REQUEST_SET_SAMPLE_RATE 1002
#define SOUND_REQUEST_SET_NR_CHANNELS 1003
#define SOUND_REQUEST_SET_BITS        1004
#define SOUND_REQUEST_PLAY_SAMPLE     1005

struct sound_mixer {
  float wind_noise_amplitude;
  float echo_amplitude;
  float sample_amplitude;
  float output_amplitude;
};

struct sound_echo {
  float delay;			/* Echo delay (seconds). */
  float level;			/* Echo level (0-1). */
};

struct sound_misc {
  float craft_velocity;		/* Craft velocity in display units. */
};

/* Format of shared memory. */
struct sound_shm {
  struct sound_mixer mixer;
  struct sound_echo echo;
  struct sound_misc misc;

#if SOUND_USE_FORK
  int num_sound_requests;
  struct sound_request request [SOUND_SHM_MAX_REQUESTS];
#endif
};

struct sound_process_data {
  int pipe_fd;
  struct sound_shm *shm;
  int audio_fd;
  int sample_rate;
  int nr_channels;
  int bits;
  int enabled;
};

extern void sound_process (const struct sound_process_data *data);

extern void load_samples (void);

#endif /* __sound_process_h__ */
