/* Test optimization of polygons into triangle fans
 * and quad strips. Does this improve drawing speed?
 */

#ifdef __CYGWIN32__
#include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>

#include <math.h>

static int width = 640, height = 480;
static int nr_iters = 100000;
static int frame = 0;
static int lists[4];
static GLfloat v[9][3] = {
  { 0, 0, 0 },
  { 1, 0, 0 },
  { 1, 1, 0 },
  { 0, 1, 0 },
  { -1, 1, 0 },
  { -1, 0, 0 },
  { -1, -1, 0 },
  { 0, -1, 0 },
  { 1, -1, 0 }
};

static void display (void);
static void reshape (int, int);

static inline long long
rdtsc ()
{
  long long d;
  __asm__ __volatile__ ("rdtsc" : "=&A" (d));
  return d;
}

int
main (int argc, char *argv[])
{
  putenv ("FX_GLIDE_NO_SPLASH=1");

  glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH);
  glutInitWindowSize (width, height);
  glutCreateWindow ("test-poly-opts");

  glClearColor (0, 0, 0, 0);

  glEnableClientState (GL_VERTEX_ARRAY);

  /* Set up list of points. */
  glVertexPointer (3, GL_FLOAT, 0, v);

  /* Set up polygon display list. */
  lists[0] = glGenLists (1);
  glNewList (lists[0], GL_COMPILE);
  glBegin (GL_POLYGON);
  glArrayElement (0);
  glArrayElement (1);
  glArrayElement (2);
  glEnd ();
  glBegin (GL_POLYGON);
  glArrayElement (0);
  glArrayElement (2);
  glArrayElement (3);
  glEnd ();
  glBegin (GL_POLYGON);
  glArrayElement (0);
  glArrayElement (3);
  glArrayElement (4);
  glEnd ();
  glBegin (GL_POLYGON);
  glArrayElement (0);
  glArrayElement (4);
  glArrayElement (5);
  glEnd ();
  glBegin (GL_POLYGON);
  glArrayElement (0);
  glArrayElement (5);
  glArrayElement (6);
  glEnd ();
  glBegin (GL_POLYGON);
  glArrayElement (0);
  glArrayElement (6);
  glArrayElement (7);
  glEnd ();
  glBegin (GL_POLYGON);
  glArrayElement (0);
  glArrayElement (7);
  glArrayElement (8);
  glEnd ();
  glBegin (GL_POLYGON);
  glArrayElement (0);
  glArrayElement (8);
  glArrayElement (1);
  glEnd ();
  glEndList ();

  /* Set up equivalent triangle fan display list. */
  lists[1] = glGenLists (1);
  glNewList (lists[1], GL_COMPILE);
  glBegin (GL_TRIANGLE_FAN);
  glArrayElement (0);
  glArrayElement (1);
  glArrayElement (2);
  glArrayElement (3);
  glArrayElement (4);
  glArrayElement (5);
  glArrayElement (6);
  glArrayElement (7);
  glArrayElement (8);
  glEnd ();
  glEndList ();

  /* Set up polygon display list. */
  lists[2] = glGenLists (1);
  glNewList (lists[2], GL_COMPILE);
  glBegin (GL_POLYGON);
  glArrayElement (6);
  glArrayElement (5);
  glArrayElement (0);
  glArrayElement (7);
  glEnd ();
  glBegin (GL_POLYGON);
  glArrayElement (5);
  glArrayElement (4);
  glArrayElement (3);
  glArrayElement (0);
  glEnd ();
  glEndList ();

  /* Set up equivalent quad strip display list. */
  lists[3] = glGenLists (1);
  glNewList (lists[3], GL_COMPILE);
  glBegin (GL_QUAD_STRIP);
  glArrayElement (7);
  glArrayElement (6);
  glArrayElement (0);
  glArrayElement (1);
  glArrayElement (3);
  glArrayElement (4);
  glEnd ();
  glEndList ();

  glutReshapeFunc (reshape);
  glutDisplayFunc (display);

  glutMainLoop ();

  exit (0);
}

void
reshape (int w, int h)
{
  width = w;
  height = h;

  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluPerspective (50, (GLfloat) w / (GLfloat) h, 1, 1000);
}

static void
display ()
{
  int i, error;
  double a;
  long long start, stop;

  /* Clear the window. */
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  /* Draw it. */
  start = rdtsc ();
  for (a = 0, i = 0; i < nr_iters; a += 0.01, ++i)
    {
      /* Move eye position. */
      glMatrixMode (GL_MODELVIEW);
      glLoadIdentity ();
      gluLookAt (0, 0.2, 0,
		 sin (a), cos (a), 0,
		 0, 0, 1);

      glCallList (lists[frame]);
    }

  error = glGetError ();
  if (error != GL_NO_ERROR)
    {
      fprintf (stderr, "GL error: %s", gluErrorString (error));
      exit (1);
    }

  glFlush ();

  stop = rdtsc ();
  printf ("list = %d; time = %Ld\n", frame, stop - start);

  glutSwapBuffers ();

  glutPostRedisplay ();

  frame ++;

  if (frame >= 4)
    exit (0);
}
