// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: laser.C,v 3.7 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "trig.h"
#include "util.h"
#include "xsc.h"

#include "laser.h"

using namespace Trig;


Laser::Laser(void)
{
    //fprintf(stderr, "Laser::Laser()\n");
    set_scale(175.0);
    lifespan = wwidth * 0.70;
    age = lifespan;
    mag = (wwidth / 2.0) / args.fps;
} // Laser::Laser


Laser::~Laser(void)
{
    //fprintf(stderr, "Laser::~Laser()\n");
} // Laser::~Laser


void
Laser::resize(const int nwidth, const int nheight)
{
    const float nlifespan = nwidth * 0.75;
    const float deg = ship->get_theta();

    if (alive()) {
	age *= nlifespan / lifespan;
    } else {
	age = nlifespan;
    }
    lifespan = nlifespan;

    mag = (nwidth / 2.0) / args.fps;
    dx = xcos(deg) + ship->get_dx() / mag;
    dy = -xsin(deg) + ship->get_dy() / mag;
    Thing::resize(nwidth, nheight);

    if (size < 2.0) {
	size = 2.0;
    }
} // Laser::resize


void
Laser::render(const bool ink)
{
    if (!alive()) {
	return;
    }

    XFillArc(display, window, (ink ? gc : fetch_gc(GC_BLACK)),
	    (int)(x - (size / 2.0)),
	    (int)(y - (size / 2.0)),
	    (int)size, (int)size,
	    0, 360*64);
} // Laser::render


void
Laser::move(Castle *castle, King *king, Minefield *minefield, Stats *stats)
{
    for (int i = 0; i < mag && alive(); i++) {
	Xything::move();
	if (castle->collision(this, stats) ||
		king->hit(castle, this, minefield, stats) ||
		minefield->hit(this)) {
	    snuff();
	} else {
	    age += hypot(dx, dy);
	}
    }
} // Laser::move


void
Laser::launch(void)
{
    const float deg = ship->get_theta();

    x = ship->get_x();
    y = ship->get_y();

    dx = xcos(deg) + ship->get_dx() / mag;
    dy = -xsin(deg) + ship->get_dy() / mag;

    age = 0;
} // Laser::launch
