// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: stamp.C,v 3.7 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "stamp.h"


Stamp::Stamp(void)
{
    //fprintf(stderr, "Stamp::Stamp()\n");
} // Stamp::Stamp


Stamp::~Stamp(void)
{
    //fprintf(stderr, "Stamp::~Stamp()\n");
} // Stamp::~Stamp


Stamp &
Stamp::operator=(const long l)
{
    sec = l;
    usec = 0;

    return *this;
} // Stamp::operator=


bool
Stamp::operator==(const Stamp &s) const
{
    return (sec == s.sec) && (usec == s.usec);
} // Stamp::operator==


bool
Stamp::operator!=(const Stamp &s) const
{
    return !(*this == s);
} // Stamp::operator!=


Stamp &
Stamp::operator+=(const Stamp &s)
{
    sec += s.sec;
    usec += s.usec;

//    normalize();

    return *this;
} // Stamp::operator+


Stamp &
Stamp::operator-=(const Stamp &s)
{
    sec -= s.sec;
    usec -= s.usec;

//    normalize();

    return *this;
} // Stamp::operator-


bool
Stamp::operator>(const long x)
{
    return micros() > x;
} // Stamp::operator>


bool
Stamp::operator<(const long x)
{
    return micros() < x;
} // Stamp::operator<


long
Stamp::micros(void) const
{
    return (sec * 1000000) + usec;
} // Stamp::micros


void
Stamp::normalize(void)
{
    while (usec < 0) {
	sec--;
	usec += 1000000;
    }

    while (usec >= 1000000) {
	sec++;
	usec -= 1000000;
    }
} // Stamp::normalize


// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-


Stamp
operator+(const Stamp &s1, const Stamp &s2)
{
    Stamp s = s1;

    return s += s2;
} // ::operator+


Stamp
operator-(const Stamp &s1, const Stamp &s2)
{
    Stamp s = s1;

    return s -= s2;
} // ::operator-
