// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: stamp.h,v 3.8 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_STAMP_H

class Stamp;

#else	// XSC_STAMP_H
#define	XSC_STAMP_H

class Stamp {
private:
    long sec;
    long usec;

public:
    Stamp(void);
    ~Stamp(void);

    Stamp &operator=(const long);
    bool operator==(const Stamp &) const;
    bool operator!=(const Stamp &) const;
    Stamp &operator+=(const Stamp &);
    Stamp &operator-=(const Stamp &);
    bool operator>(const long);
    bool operator<(const long);

    long micros(void) const;
    void normalize(void);

    operator float() const;
    void set(const long, const long);
    long get_sec(void) const;
    long get_usec(void) const;
};

extern Stamp operator+(const Stamp &s1, const Stamp &s2);
extern Stamp operator-(const Stamp &s1, const Stamp &s2);


inline
Stamp::operator float() const
{
    return (float)(sec + (usec / 1000000.0));
} // Stamp::operator float


inline void
Stamp::set(const long s, const long u)
{
    sec = s;
    usec = u;
} // Stamp::set


inline long
Stamp::get_sec(void) const
{
    return sec;
} // Stamp::get_sec


inline long
Stamp::get_usec(void) const
{
    return usec;
} // Stamp::get_usec

#endif	// XSC_STAMP_H
