// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: buzzer.h,v 3.7 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_BUZZER_H

class Buzzer;

#else	// XSC_BUZZER_H
#define	XSC_BUZZER_H

#include "castle.h"
#include "king.h"
#include "laser.h"
#include "ship.h"
#include "stats.h"
#include "xything.h"

class Buzzer : public virtual Xything {
private:
    bool flying;
    float *randomizer;
    bool *riding_on;		// number of rings
    float speed;
    bool paused;

    void set_randomizer(void);

public:
    Buzzer(void);
    ~Buzzer(void);

    void render(const bool);

    void move(Castle *, Ship *);
    void launch(King *, Castle *);
    bool hit(Laser *);
    void set_xpoints(void);
    void upgrade(Castle *);
    void resize(const int, const int);

    bool alive(void) const;
    void snuff(void);
    void pause(const bool);
};


inline bool
Buzzer::alive(void) const
{
    return flying;
} // Buzzer::alive


inline void
Buzzer::snuff(void)
{
    flying = false;
} // Buzzer::snuff


inline void
Buzzer::pause(const bool pause_state)
{
    paused = pause_state;
} // Buzzer::pause

#endif	// XSC_BUZZER_H
