// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: trig.C,v 3.7 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "util.h"
#include "xsc.h"

#include "trig.h"


namespace {

const int N = 4;
float sintab[90 * N];

float
sinlook(const float angle)
{
    const int a = (int)(Trig::normalize(angle) + 0.5);
    float retval;

    if (a < 90) {
	retval = sintab[a * N];
    } else if (a == 90) {
	retval = 1.0;
    } else if (a < 180) {
	retval = sintab[(180 - a) * N];
    } else if (a < 270) {
	retval = -sintab[(a - 180) * N];
    } else if (a == 270) {
	retval =-1.0;
    } else {
	retval = -sintab[(360 - a) * N];
    }

    return retval;
} // ::sinlook

} // namespace


void
Trig::init(void)
{
    for (int angle = 0; angle < 90 * N; angle++) {
	sintab[angle] = sin(deg2rad(angle / (float)N));
    }
} // Trig::init


float
Trig::xsin(const float degrees)
{
    return sinlook(degrees);
} // Trig::xsin


float
Trig::xcos(const float degrees)
{
    return sinlook(degrees + 90.0);
} // Trig::xcos


float
Trig::xatan2(const float y, const float x)
{
    return rad2deg(atan2(y, x)) + 180.0;
} // Trig::xatan2


float
Trig::wedge(const float here, const float there)
{
    const float h = Trig::normalize(here);
    const float t = Trig::normalize(there);
    float diff = fabs(t - h);
    int direction = sign(t - h);

    if (diff >= 180.0) {
	diff = 360.0 - diff;
	direction = -direction;
    }

    return (diff * direction);
} // Trig::wedge
