// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: util.C,v 3.4 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "util.h"
#include "xsc.h"

namespace {

GC gc_list[GC_TOKEN_COUNT];

void
alloc_color(const char *const name, XColor *color)
{
    const int screen_number = DefaultScreen(display);
    XColor dummy;
    Colormap colormap = DefaultColormap(display, screen_number);

    if (XAllocNamedColor(display, colormap, name, color, &dummy) == 0) {
	fprintf(stderr, "%s: failed to allocate color `%s'.  ", program, name);
	fprintf(stderr, "substituting `white'.\n");
	if (XAllocNamedColor(display, colormap, "white", color,
		    &dummy) == 0) {
	    fprintf(stderr, "%s: failed to allocate color `white'.\n", program);
	}
    }
} // ::alloc_color


GC
alloc_gc(const char *const colorname, const int width)
{
    const int screen_number = DefaultScreen(display);
    XColor color;
    XGCValues gc_values;

    gc_values.line_width = width;
    gc_values.background = BlackPixel(display, screen_number);

    alloc_color(colorname, &color);
    gc_values.foreground = color.pixel;

    return XCreateGC(display, RootWindow(display, screen_number),
	(GCForeground | GCBackground | GCLineWidth), &gc_values);
} // ::alloc_gc

} // namespace


void
init_gc(void)
{
    gc_list[GC_BLACK] = alloc_gc("black", 2);

    gc_list[GC_BRIGHT_RED] = alloc_gc("red", 2);
    gc_list[GC_DULL_RED] = alloc_gc("red3", 2);

    gc_list[GC_BRIGHT_ORANGE] = alloc_gc("orange", 2);
    gc_list[GC_DULL_ORANGE] = alloc_gc("orange3", 2);

    gc_list[GC_BRIGHT_YELLOW] = alloc_gc("yellow", 2);
    gc_list[GC_DULL_YELLOW] = alloc_gc("yellow3", 2);

    gc_list[GC_BRIGHT_GREY] = alloc_gc("grey80", 2);
    gc_list[GC_DULL_GREY] = alloc_gc("grey40", 2);

    gc_list[GC_GREEN] = alloc_gc("green", 2);

    gc_list[GC_BLUE] = alloc_gc("dodgerblue", 2);
} // ::init_gc


void
free_all_gcs(void)
{
    XFreeGC(display, gc_list[GC_BLACK]);

    XFreeGC(display, gc_list[GC_BRIGHT_RED]);
    XFreeGC(display, gc_list[GC_DULL_RED]);

    XFreeGC(display, gc_list[GC_BRIGHT_ORANGE]);
    XFreeGC(display, gc_list[GC_DULL_ORANGE]);

    XFreeGC(display, gc_list[GC_BRIGHT_YELLOW]);
    XFreeGC(display, gc_list[GC_DULL_YELLOW]);

    XFreeGC(display, gc_list[GC_BRIGHT_GREY]);
    XFreeGC(display, gc_list[GC_DULL_GREY]);

    XFreeGC(display, gc_list[GC_BLUE]);

    XFreeGC(display, gc_list[GC_GREEN]);
} // ::free_all_gcs


GC
fetch_gc(const gc_token t)
{
    return gc_list[t];
} // ::fetch_gc
