/* c_base.hh 1.14 95/12/23 03:11:29 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// class for describing the Federation base ships

#ifndef _BASE_
#define _BASE_

#include "c_ship.hh"
#include <X11/Xlib.h>
#include "space_objects.hh"

class Base: public Ship
{
public:
  Base();
  Identity what() const {return (BASE);}
  void die(Identity cause);
  void draw(Drawable drawable, GC gc) const;
  void energize();
  int getmaxerg() const {return (maxerg);}
  static void setpop(int p);
  static int getpop();
  static void seticon(const char *str);
  static int geticon_len();
private:
  static int pop;		// number of bases remaining
  static char icon[];
  static const int icon_len;
  static const int maxerg;  // max energy for shields, thrust, warp, or fasers
};


#endif				// _BASE_

// end
