/* c_block.cc 1.4 95/12/23 03:11:46 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// define the member functions of class Block


#include <stdlib.h>		// exit()
#include <iostream.h>		// cerr
#include "common.hh"
#include "params.hh"
#include "globals.hh"		// app_data describes game window dimensions
#include "c_block.hh"

// default constructor

Block::Block()
{
  row = 0;
  col = 0;
}

// construct given row/col in game window

Block::Block(int r, int c)
{
  if (r < 0 || r >= GAMEROWS || c < 0 || c >= GAMECOLS)
  {
    cerr << "xspacewarp: class block: row or column out of bounds." << endl;
    exit(1);
  }
  row = r;
  col = c;
}

// copy constructor

Block::Block(const Block& b)
{
  row = b.row;
  col = b.col;
}


Block& Block::operator=(const Block& b)
{
  row = b.row;
  col = b.col;
  return (*this);
}

  
void Block::setrow(int r)
{
  if (r < 0 || r > GAMEROWS)
  {
    cerr << "xspacewarp: class block: row out of range." << endl;
    exit(1);
  }
  row = r;
}

  
void Block::setcol(int c)
{
  if (c < 0 || c > GAMECOLS)
  {
    cerr << "xspacewarp: class block: column out of range." << endl;
    exit(1);
  }
  col = c;
}

// Member functions for converting row/col positions of a block
// to pixels positions relative to the (0,0) pixel of the
// playing area.

// Return the "text origin" of a 9x15 block, ie the pixel
// position to feed to XDrawString() so that the font will stay
// completely inside the block.

Point Block::origin() const
{
  Point point;

  point.x = BLOCKW*col + TEXTORIGINX;
  point.y = BLOCKH*row + TEXTORIGINY;

  return (point);
}


// Return the pixel position of the center of a 9x15 block. This
// is used to find positions for drawing lines.

Point Block::center() const
{
  Point point;

  point.x = BLOCKW*col + BLOCKHALFW;
  point.y = BLOCKH*row + BLOCKHALFH;

  return (point);
}


// Return the pixel position of the northwest (upper-left)
// corner of a 9x15 block.

Point Block::northwest() const
{
  Point point;

  point.x = BLOCKW*col;
  point.y = BLOCKH*row;

  return (point);
}


// Return the pixel position of the northeast corner of a 9x15
// block.

Point Block::northeast() const
{
  Point point;

  point.x = BLOCKW*(col + 1) - 1;
  point.y = BLOCKH*row;

  return (point);
}


// Return the pixel position of the southeast corner of a 9x15
// block.

Point Block::southeast() const
{
  Point point;

  point.x = BLOCKW*(col + 1) - 1;
  point.y = BLOCKH*(row + 1) - 1;

  return (point);
}


// Return the pixel position of the southwest corner of a 9x15
// block.

Point Block::southwest() const
{
  Point point;

  point.x = BLOCKW*col;
  point.y = BLOCKH*(row + 1) - 1;

  return (point);
}

// end
