/* c_body.cc 1.10 95/12/23 03:11:27 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// define methods for class Body.

#include "c_body.hh"
#include <stdlib.h>		// exit()
#include <iostream.h>		// cerr
#include "common.hh"
#include "params.hh"
#include "globals.hh"		// toplevel for display
#include "c_block.hh"


// return the center point of the central 9x15 block of the body.

Point Body::center() const
{
  Block block;

  block.setrow(SECTROW+row);
  block.setcol(SECTCOL+col);
  return (block.center());
}


// establish the row within the universe matrix (from 1 to UROWS)

void Body::seturow(int ur)
{
  if (ur < 1 || ur > UROWS)
  {
    cerr << "xspacewarp: class Body: row outside of universe." << endl;
    exit(1);
  }
  urow = ur;
}


// establish the column within the universe matrix (from 1 to UCOLS)

void Body::setucol(int uc)
{
  if (uc < 1 || uc > UCOLS)
  {
    cerr << "xspacewarp: class Body: column outside of universe." << endl;
    exit(1);
  }
  ucol = uc;
}


// establish the row position of the body within the sector

void Body::setrow(int r)
{
  if (r < 0 || r >= SECTROWS)
  {
    cerr << "xspacewarp: class Body: row outside of sector." << endl;
    exit(1);
  }
  row = r;
}


// establish the column position of the body within the sector

void Body::setcol(int c)
{
  if (c < 0 || c >= SECTCOLS)
  {
    cerr << "xspacewarp: class Body: column outside of sector." << endl;
    exit(1);
  }
  col = c;
}


// draw the icon on the drawing canvas

void Body::draw(Drawable drawable, GC gc, const char *str, int len) const
{
  Block block;
  Point origin;

  block.setrow(SECTROW + row);
  block.setcol(SECTCOL + col - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, drawable, gc, origin.x, origin.y, str, len);
}

// end
