/* c_body.hh 1.10 95/12/23 03:11:29 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// the base class for the space object hierarchy.
// hierarchy is as follows:
//
//               _____________Body__________________
//              |                                   |
//    ________Ship________                 ______Celestial______  
//   |                    |               |                     |
// Base          ____Combatant____       Star               Blackhole
//              |                 |
//            Jovian           Endever
//
//
//

#ifndef _BODY_
#define _BODY_

#include <X11/Xlib.h>		// for draw method
#include "common.hh"
#include "space_objects.hh"

class Body
{
public:
  Body(): urow(0), ucol(0), row(0), col(0) {}
  virtual Identity what() const = 0;
  virtual void seturow(int ur);
  virtual void setucol(int uc);
  virtual void setrow(int r);
  virtual void setcol(int c);
  int geturow() const {return (urow);}
  int getucol() const {return (ucol);}
  int getrow() const {return (row);}
  int getcol() const {return (col);}
  Point center() const;
  virtual void draw(Drawable drawable, GC gc, const char *str, int len) const;
protected:
  // coords within the universe (range 1 to UROWS or UCOLS)
  int urow, ucol;

  // coords within the sector (range 0 to SECTROWS-1 or SECTCOLS-1)
  int row, col;
};


#endif				// _BODY_

// end
