/* c_jovian.hh 1.15 95/12/28 00:42:29 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// class for describing jovians

#ifndef _JOVIAN_
#define _JOVIAN_

#include "c_combatant.hh"
#include <X11/Xlib.h>
#include "common.hh"
#include "space_objects.hh"


class Jovian: public Combatant
{
public:
  Jovian();
  Identity what() const {return (JOVIAN);}
  int getid() const {return (id);}
  void setid(int i);
  void die(Identity cause);
  void draw(Drawable drawable, GC gc) const;
  void update();
  void energize();
  int getmaxerg() const {return (maxerg);}
  static void init_ai();		// initialize static AI data
  static void setpop(int p);
  static int getpop();
  static void seticon(const char *str);
  static int geticon_len();
  static void setleapflag(bool b){leapflag = b;}
  static void setleapable(int n);
  static void addleapable(int n);
  static void setraidable(int n);
  static void addraidable(int n);
private:
  int id;		// identification number for each instance.
  void move(Direction dir); // ion thrusters
  void leap(Ucoors uc);		// warpdrive
  void shoot(Point to);		// fasers

  // static data

  static int pop;	// population of jovians remaining in game
  static char icon[];
  static const int icon_len;
  static const int maxerg; // max energy for shields, thrust, warp, or fasers
  static bool leapflag;	   // set this to false before invoking jovian ai
			   // functions each time jovian_to() gets called.
			   // The ai functions will set this to
			   // true if some jovian makes a leap. Afterwards,
			   // no jovians will leap until the next call on
			   // jovian_to() timeout. This way at most one
			   // jovian can make a leap on any call to
			   // jovian_to().
  static bool raidflag;	   // Like leapflag but controls whether jovians
			   // are allowed to make a raid on a base. At most
			   // one raid is allowed per call on jovian_to().
  static int leapable;	   // The number of jovians eligible for leaping;
			   // ie, their sectors contain neither a base nor
			   // the endever.
  static int raidable;	   // The number of jovians eligible for mounting
			   // a raid on a base; ie, their sectors contain
			   // a base but not the endever.


  // AI related functions and data

  void init_ai_flags(); // initialize the non-static ai data
  Decision decide();
  void act(Decision d);
  // AI functions for filling in the Decision struct
  Action pick_action();
  Direction pick_direction();
  Ucoors pick_sector();
  Point pick_target();
  Direction retreat_direction();
  bool retreat_flag;	    // set to true if jovian is running away
  bool forcedvert;          // set to true if jovian was forced to move
			    // vertically to go around an obstacle.
  bool forcedhoriz;         // set to true if jovian was forced to move
			    // horizontally to go around an obstacle.
  bool israiding;	    // set to true if this jovian is mounting
			    // a raid on a base. once set to true, the jovian
			    // will attack the base until destroyed. The
			    // flag gets reset back to false when the base is
			    // destroyed or when the endever enters the sector.
  // bool blocked is declared in c_combatant.hh so it is easier to 
  // access in the c_combatant.cc functions.
};


// for keeping doubly linked list of jovians

struct Jovian_rec
{
  Jovian_rec *prev, *next;
  Jovian *jov_pt;
};


#endif				// _JOVIAN_

// end
