/* draw_intro.cc 1.12 95/12/23 03:11:38 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// draw the introductory message when xspacewarp begins

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "common.hh"
#include "params.hh"
#include "globals.hh"		// access toplevel
#include "c_block.hh"
#include "messages.hh"


extern void echo(const char *, int);


void draw_intro(void)
{
  Block block;
  Point origin;
  int len;

  // clear previous stuff

  XFillRectangle(DISPLAY, pixmap, defrv_GC, 0, 0, GAMEW, GAMEH);

  // draw title string

  len = XtNumber(intro_title_str) - 1;
  block.setrow(GAMEROWS/2 - 1);
  block.setcol(GAMECOLS/2 - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      intro_title_str, len);

  // draw originator string

  len = XtNumber(intro_originator_str) - 1;
  block.setrow(GAMEROWS - 5);
  block.setcol(GAMECOLS/2 - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      intro_originator_str, len);

  // draw port string

  len = XtNumber(intro_port_str) - 1;
  block.setrow(GAMEROWS - 4);
  block.setcol(GAMECOLS/2 - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      intro_port_str, len);

  // copy to window

  XCopyArea(DISPLAY, pixmap, XtWindow(widget),
	    def_GC, 0, 0, GAMEW, GAMEH, 0, 0);

  // draw skill string

  len = XtNumber(intro_skill_str) - 1;
  echo(intro_skill_str, len);
}

// end
