/* draw_sector.cc 1.8 95/12/23 03:11:39 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// draws the rectangular frame for the sector display. the
// sector class has its own method for drawing the icons of all
// the space objects inside the sector. draw_sector() calls this
// method.


#include <stdlib.h>		// exit()
#include <iostream.h>		// cerr
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "common.hh"
#include "params.hh"
#include "globals.hh"		// access toplevel
#include "c_block.hh"
#include "c_sector.hh"


// all drawing is done on pixmap then copied to window

void draw_sector(void)
{
  Block block1, block2;
  Point point1, point2;

  // clear previous stuff

  XFillRectangle(DISPLAY, pixmap, defrv_GC, 0, 0, GAMEW, GAMEH);

  // draw frame for sector display

  // top line

  block1.setrow(SECTROW-1);
  block1.setcol(SECTCOL-1);
  block2.setrow(SECTROW-1);
  block2.setcol(SECTCOL+SECTCOLS);
  point1 = block1.southeast();
  point2 = block2.southwest();
  XDrawLine(DISPLAY, pixmap, def_GC, point1.x, point1.y, point2.x, point2.y);
  
  // bottom line

  block1.setrow(SECTROW+SECTROWS);
  block2.setrow(SECTROW+SECTROWS);
  point1 = block1.northeast();
  point2 = block2.northwest();
  XDrawLine(DISPLAY, pixmap, def_GC, point1.x, point1.y, point2.x, point2.y);

  // left line

  block2.setrow(SECTROW-1);
  block2.setcol(SECTCOL-1);
  point2 = block2.southeast();
  XDrawLine(DISPLAY, pixmap, def_GC, point1.x, point1.y, point2.x, point2.y);

  // right line

  block1.setcol(SECTCOL+SECTCOLS);
  block2.setcol(SECTCOL+SECTCOLS);
  point1 = block1.northwest();
  point2 = block2.southwest();
  XDrawLine(DISPLAY, pixmap, def_GC, point1.x, point1.y, point2.x, point2.y);

  // draw ships, etc inside the frame drawn above

  universe[endever.geturow()-1][endever.getucol()-1].draw(pixmap);

  // copy pixmap to window

  XCopyArea(DISPLAY, pixmap, XtWindow(widget),
	    def_GC, 0, 0, GAMEW, GAMEH, 0, 0);
}


// end
