/* draw_winlose.cc 1.5 95/12/28 23:35:33 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// draw the "You Won" and "You Lost" messages when game is over.


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "common.hh"
#include "params.hh"
#include "globals.hh"
#include "c_block.hh"
#include "messages.hh"

static void printmesg(const char *msg, int msglen);


// if endever won

void draw_winmesg(void)
{
  printmesg(win_str, XtNumber(win_str)-1);
}


// if endever lost

void draw_losemesg(void)
{
  printmesg(lose_str, XtNumber(lose_str)-1);
}


// for doing the actual drawing

static void printmesg(const char *msg, int msglen)
{
  int tmplen;
  Block block;
  Point origin, nw;

  // draw "msg" argument

  block.setrow(SECTROW + SECTROWS/2);
  block.setcol(SECTCOL + SECTCOLS/2 - msglen/2);
  origin = block.origin();
  nw = block.northwest();

  // give message a black background (ie, default background
  // color) for contrast

  XFillRectangle(DISPLAY, XtWindow(widget), defrv_GC, nw.x, nw.y, 9*msglen, 15);
  XFillRectangle(DISPLAY, pixmap, defrv_GC, nw.x, nw.y, 9*msglen, 15);
  XDrawString(DISPLAY, XtWindow(widget), def_GC,
	      origin.x, origin.y, msg, msglen);
  XDrawString(DISPLAY, pixmap, def_GC,
	      origin.x, origin.y, msg, msglen);

  // draw "replay_mesg"

  tmplen = XtNumber(replay_str) - 1;
  block.setrow(SECTROW + SECTROWS/2 + 4);
  block.setcol(SECTCOL + SECTCOLS/2 - tmplen/2);
  origin = block.origin();
  nw = block.northwest();

  // give message a black background
  
  XFillRectangle(DISPLAY, XtWindow(widget), defrv_GC, nw.x, nw.y, 9*tmplen, 15);
  XFillRectangle(DISPLAY, pixmap, defrv_GC, nw.x, nw.y, 9*tmplen, 15);
  XDrawString(DISPLAY, XtWindow(widget), def_GC,
	      origin.x, origin.y, replay_str, tmplen);
  XDrawString(DISPLAY, pixmap, def_GC,
	      origin.x, origin.y, replay_str, tmplen);
}

// end
