/* space_objects.hh 1.7 95/12/23 03:11:31 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// data types useful for space object methods.


#ifndef _SPACEOBJ_
#define _SPACEOBJ_

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "common.hh"


enum Identity {NOTHING, BASE, BLACKHOLE, ENDEVER, JOVIAN, STAR}; // object types
enum Direction {STAY, UP, DOWN, LEFT, RIGHT}; // for ion thrusters
enum Weapon {FASER, TORPEDO};
enum Damage {NONFATAL, FATAL};	// see Ship::hit()
enum Action {NONE, MOVE, LEAP, SHOOT}; // for jovian artificial intelligence

struct Energy
{
  int thrusters;
  int warpdrive;
  int fasers;
  int shields;
};

struct Shot			// for fasers/torpedoes
{
  Weapon weapon;		// what is being fired
  float energy;		// percent energy level of fasers
  Identity source;		// who fired it
  Point start;		// position where shot originated: to compute intensity
  FPoint delta;	// change in x,y positions of shot endpoints between time steps
  FPoint f_from;		// tail of shot (float for better angle resolve)
  FPoint f_to;			// head of shot (float for better angle resolve)
  Point from;		// tail of shot (int version)
  Point to;		// head of shot (int version)
  float sin;		// sin(theta), theta = firing angle in std position
  float cos;		// cos(theta)
  bool inprogress;	// flag whether a shot already in progress
  bool fixend;	// whether to fix the leading end of the shot
  XtIntervalId id;
};


struct HitReport		// detect_hit() returns this
{
  Damage damage;	// damage done by hit
  Identity what;	// what got hit
  Point newto;		// new value for "to" endpoint
};

struct Explosion
{
  Point center;			// center of explosion
  int limit;			// furthest radial extent of explosion
  int radius;			// current radius of explosion
  XtIntervalId id;
};

// artificial intelligence data types for Jovians
// enum Action gives general description of how jovian behaves and
// union Details elaborates on this. struct Decision completely
// describes how a jovian is supposed to act.

union Details
{
  Direction direct;
  Ucoors sector;
  Point target;
};

struct Decision
{
  Action action;
  Details details;
};
  

#endif                 // _SPACEOBJ_




// end
