/* c_ship.hh 1.11 95/12/23 03:11:30 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// abstract class for describing space ships

#ifndef _SHIP_
#define _SHIP_

#include "c_body.hh"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "common.hh"
#include "space_objects.hh"

class Ship: public Body
{
public:
  Ship(): Body() {}
  Damage hit(const Shot& sh);
  void expand();
protected:
  Energy energy;		// the energy levels for this ship
  Explosion explosion;	    // struct for managing explosion when ship dies
  virtual void die(Identity cause) = 0;
  virtual void energize() = 0;
  virtual int getmaxerg() const = 0; // virtual so base class can get child data
  void explode(int r);
  bool visible() const;
  bool on_edge() const;
private:
  Point randfrag();
  double severity(const Shot& sh);
};


#endif				// _SHIP_

// end
