/* common.hh 1.13 95/12/28 23:24:14 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// some of the structs, enums, inlines and defines used throughout this program.

#ifndef _COMMON_
#define _COMMON_

// Xlib related macros

#define DISPLAY XtDisplay(toplevel)
#define WINDOW XtWindow(widget)
#define SCREEN DefaultScreen(DISPLAY)
#define DEPTH DefaultDepth(DISPLAY, SCREEN)
#define BLACK BlackPixel(DISPLAY, SCREEN)
#define WHITE WhitePixel(DISPLAY, SCREEN)
#define DEFGC DefaultGC(DISPLAY, SCREEN)
#define COLORMAP DefaultColormap(DISPLAY, SCREEN)

// VisualState: flags indicating what is currently being displayed

enum VisualState {INTRO, LOSE, MISSION, ORIENTATION, SCANNER,
		  SECTOR, SUMMARY, WIN};

// InputState: flags specifying how input keystokes are to be interpreted.
// ACTION: keystrokes translated to faser shots, warp leaps, display changes...
// ANGLE: keystrokes translated to a trajectory angle.
// DESTRUCT: keystrokes translated to the 7 1-2-3 self-destruct act.
// NEWSECTOR: keystrokes interpreted as coors of a new sector to warp to.
// SHIELDS: input keystrokes translated to a new shield level.
// SKILL: input keystrokes translated to a skill level at beginning of game.

enum InputState {ACTION, CODE, FASERANGLE, NEWSECTOR, REPLAY,
		 SHIELDLEVEL, SKILL, TORPANGLE, PAUSE};

typedef struct
{
  int skill;			// skill level
  VisualState visual;		// what the player sees
  InputState input;		// how keyboard input interpreted
} GameState;

#ifndef NULL
#define NULL 0
#endif

typedef struct		// for pixel locations in plotting
{
  int x;
  int y;
} Point;

// floating point version of struct Point

typedef struct
{
  float x;
  float y;
} FPoint;

// double precision version of struct Point

typedef struct
{
  double x;
  double y;
} DPoint;

typedef struct			// for coordinates in universe matrix
{				// should have made more use of this...
  int urow;
  int ucol;
} Ucoors;

typedef struct			// for position within a sector
{
  int srow;
  int scol;
} Scoors;


// useful math macros

inline int max(int i, int j){return ((i >= j) ? i:j);}
inline int min(int i, int j){return ((i <= j) ? i:j);}
inline float max(float x, float y){return ((x >= y) ? x:y);}
inline float min(float x, float y){return ((x <= y) ? x:y);}
inline int sgn(int i){return (i <= 0 ? (i ? -1:0):1);} // return sign of int

// square of euclidean distance between two points

inline long sqdist(Point p, Point q)
{
  return ((long)(p.x - q.x)*(long)(p.x - q.x) +
	  (long)(p.y - q.y)*(long)(p.y - q.y));
}

// Given x, evaluate the linear function passing through (x1, y1)
// and (x2, y2). Caution: no error checking for division by
// zero.

inline int evallinear(int x, int x1, int y1, int x2, int y2)
{
  return (y1 + ((y2 - y1)*(x - x1)) / (x2 - x1));
}

// real valued linear function

inline float evallinear(int x, int x1, float y1, int x2, float y2)
{
  return (y1 + ((y2 - y1)*(float)(x - x1)) / (float)(x2 - x1));
}

#endif				// _COMMON_


// end
