/* main.cc 1.14 95/12/23 03:11:19 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdlib.h>		// srand()
#include <time.h>		// seed for srand()
#include "common.hh"
#include "params.hh"
#include "globals.hh"		// defines universe[][]
#include "c_sector.hh"

extern void xprep(int, char **);
extern void init_echo(void);
extern void draw_intro(void);
extern void set_summary_size(void);

int main(int argc, char **argv)
{
  int i, j;

  srand(time(0));		// afterwards, seed is changed at random
				// intervals in reseed_to()

  // set the coordinates of each sector in universe so they will
  // know their location.

  for (i = 1; i <= UROWS; i++)
  {
    for (j = 1; j <= UCOLS; j++)
    {
      universe[i-1][j-1].setucoors(i, j);
    }
  }

  toplevel = XtVaAppInitialize(&app_context,
			       "XSpacewarp",
			       NULL, 0,
			       &argc, argv,
			       NULL,
			       NULL);

  xprep(argc, argv);			// X preparation stuff

  // initialize some things with app_data

  endever.settorpedoes(MAXTORPEDOES);
  Endever::seticon(app_data.endever_icon);
  Jovian::seticon(app_data.jovian_icon);
  Base::seticon(app_data.base_icon);
  Star::seticon(app_data.star_icon);
  Blackhole::seticon(app_data.blackhole_icon);

  set_summary_size();  // internationalization:
		       // initialize the summary display dimensions
  
  init_echo();			// initialize the echo area
  draw_intro();		// must do after XtRealizeWidget()

  XtAppMainLoop(app_context);
}

// end
