/* xprep.hh 1.10 95/12/28 23:24:14 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


#ifndef _XPREP_
#define _XPREP_

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Converters.h>	// convert resource string to type long int
#include <iostream.h>
#include "app_data.hh"

inline void invalid(char *str)
{
  cerr << "xspacewarp: invalid X resources: " << str << "." << endl;
}

extern void expose(Widget, XEvent *, String *, Cardinal *);
extern void mission(Widget, XEvent *, String *, Cardinal *);
extern void orientation(Widget, XEvent *, String *, Cardinal *);
extern void move(Widget, XEvent *, String *, Cardinal *);
extern void sector(Widget, XEvent *, String *, Cardinal *);
extern void scanner(Widget, XEvent *, String *, Cardinal *);
extern void summary(Widget, XEvent *, String *, Cardinal *);
extern void leap(Widget, XEvent *, String *, Cardinal *);
extern void shields(Widget, XEvent *, String *, Cardinal *);
extern void fasers(Widget, XEvent *, String *, Cardinal *);
extern void torpedoes(Widget, XEvent *, String *, Cardinal *);
extern void selfdestruct(Widget, XEvent *, String *, Cardinal *);
extern void input(Widget, XEvent *, String *, Cardinal *);
extern void backspace(Widget, XEvent *, String *, Cardinal *);
extern void endinput(Widget, XEvent *, String *, Cardinal *);
extern void replay(Widget, XEvent *, String *, Cardinal *);
extern void pause(Widget, XEvent *, String *, Cardinal *);

static XtActionsRec actions[] =
{
  {"expose", (XtActionProc)expose},
  {"mission", (XtActionProc)mission},
  {"orientation", (XtActionProc)orientation},
  {"move", (XtActionProc)move},
  {"sector", (XtActionProc)sector},
  {"scanner", (XtActionProc)scanner},
  {"summary", (XtActionProc)summary},
  {"leap", (XtActionProc)leap},
  {"shields", (XtActionProc)shields},
  {"fasers", (XtActionProc)fasers},
  {"torpedoes", (XtActionProc)torpedoes},
  {"selfdestruct", (XtActionProc)selfdestruct},
  {"input", (XtActionProc)input},
  {"backspace", (XtActionProc)backspace},
  {"endinput", (XtActionProc)endinput},
  {"replay", (XtActionProc)replay},
  {"pause", (XtActionProc)pause}
};


// bitmap data for degenerate mouse cursor

#define bitcursor_width 1
#define bitcursor_height 1
#define bitcursor_x_hot 0
#define bitcursor_y_hot 0
static char bitcursor_bits[] = {0x01};


// default translation table for the widget in case app-defaults file missing

static const char def_trans_table[] =
" <Expose>: expose() \n\
  <Key>Up: move(up) \n\
  <Key>Down: move(down) \n\
  <Key>Left: move(left) \n\
  <Key>Right: move(right) \n\
  <Key>KP_Up: move(up) \n\
  <Key>KP_Down: move(down) \n\
  <Key>KP_Left: move(left) \n\
  <Key>KP_Right: move(right) \n\
  <Key>space: mission(start) sector() \n\
  <Key>1: input() scanner() \n\
  <Key>2: input() summary() \n\
  <Key>3: input() leap() \n\
  <Key>4: input() shields() \n\
  <Key>5: input() fasers() \n\
  <Key>6: input() torpedoes() \n\
  <Key>7: input() selfdestruct() \n\
  <Key>8: input() \n\
  <Key>9: input() \n\
  <Key>0: input() \n\
  <Key>-: input() \n\
  <Key>Return: endinput() \n\
  <Key>BackSpace: backspace() \n\
  <Key>n: orientation(next) replay(no) \n\
  <Key>o: mission(orient) \n\
  <Key>p: orientation(prev) pause() \n\
  <Key>q: orientation(quit) \n\
  <Key>y: replay(yes)";


// default values for app_data members to use when invalid
// data supplied in the X resources file.

static const AppData def_app_data =
{
  False,			// nomouse
  26,				// rows
  79,				// columns
  18,				// min_average_base_pop
  18,				// max_average_base_pop
  10,				// min_average_jovian_pop
  73,				// max_average_jovian_pop
  75,				// min_average_star_pop
  75,				// max_average_star_pop
  5,				// min_average_blackhole_pop
  5,				// max_average_blackhole_pop
  3,				// min_variation_base_pop
  3,				// max_variation_base_pop
  3,				// min_variation_jovian_pop
  3,				// max_variation_jovian_pop
  5,				// min_variation_star_pop
  5,				// max_variation_star_pop
  4,				// min_variation_blackhole_pop
  4,				// max_variation_blackhole_pop
  (Pixel) 1,			// foreground
  (Pixel) 0,			// background
  (Pixel) 1,			// endever_color
  ">-0",			// endever_icon
  (Pixel) 1,			// jovian_color
  "<*>",			// jovian_icon
  (Pixel) 1,			// base_color
  "+0+",			// base_icon
  (Pixel) 1,			// star_color
  ".",				// star_icon
  (Pixel) 0,			// blackhole_color
  " ",				// blackhole_icon
  (Pixel) 1,			// faser_color
  9,				// faser_width
  0,				// faser_dash_offset
  "4 4",			// faser_dash_list
  15L,				// faser_speed
  (Pixel) 1,			// torpedo_color
  9,				// torpedo_width
  6,				// torpedo_length
  30L,				// torpedo_speed
  (Pixel) 1,			// explosion_color
  20L,				// explosion_speed
  35,				// explosion_radius_small
  120,				// explosion_radius_big
  100L,				// endever_thrust_speed
  3000L,			// ship_energize_speed
  100L,				// jovian_action_speed
  "123",			// self_destruct_code
  0.0,				// default_firing_angle
  10,				// max_torpedoes
  3,				// max_jovians_per_sector
  5,				// max_stars_per_sector
  5,				// mask_probability
  150,				// min_jovian_distance
  10,				// endever_min_faser_energy
  20,				// endever_min_warp_energy
  10,				// endever_min_thrust_energy
  10,				// jovian_min_faser_energy
  20,				// jovian_min_warp_energy
  10,				// jovian_min_thrust_energy
  30,				// jovian_thrust_retreat_energy
  40,				// jovian_warp_retreat_energy
  30,				// jovian_faser_retreat_energy
  40,				// jovian_shield_retreat_energy
  50,				// jovian_retreat_probability
  1.0,				// jovian_retreat_speed
  3.5,				// jovian_min_fight_frequency
  1.5,				// jovian_max_fight_frequency
  400.0,			// jovian_min_raid_frequency
  40.0,				// jovian_max_raid_frequency
  400.0,			// jovian_min_leap_frequency
  40.0				// jovian_max_leap_frequency
};


// for loading application defined resources from X resources file

static XtResource resources[] =
{
  {
    XtNnomouse,
    XtCNomouse,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, nomouse),
    XtRString,
    "False"
  },
  {
    XtNrows,
    XtCRows,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, rows),
    XtRImmediate,
    (XtPointer) 26
  },
  {
    XtNcolumns,
    XtCColumns,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, columns),
    XtRImmediate,
    (XtPointer) 79
  },
  {
    XtNminAverageBasePop,
    XtCMinAverageBasePop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, min_average_base_pop),
    XtRImmediate,
    (XtPointer) 18
  },
  {
    XtNmaxAverageBasePop,
    XtCMaxAverageBasePop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_average_base_pop),
    XtRImmediate,
    (XtPointer) 18
  },
  {
    XtNminAverageJovianPop,
    XtCMinAverageJovianPop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, min_average_jovian_pop),
    XtRImmediate,
    (XtPointer) 10
  },
  {
    XtNmaxAverageJovianPop,
    XtCMaxAverageJovianPop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_average_jovian_pop),
    XtRImmediate,
    (XtPointer) 73
  },
  {
    XtNminAverageStarPop,
    XtCMinAverageStarPop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, min_average_star_pop),
    XtRImmediate,
    (XtPointer) 75
  },
  {
    XtNmaxAverageStarPop,
    XtCMaxAverageStarPop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_average_star_pop),
    XtRImmediate,
    (XtPointer) 75
  },
  {
    XtNminAverageBlackholePop,
    XtCMinAverageBlackholePop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, min_average_blackhole_pop),
    XtRImmediate,
    (XtPointer) 5
  },
  {
    XtNmaxAverageBlackholePop,
    XtCMaxAverageBlackholePop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_average_blackhole_pop),
    XtRImmediate,
    (XtPointer) 5
  },
  {
    XtNminVariationBasePop,
    XtCMinVariationBasePop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, min_variation_base_pop),
    XtRImmediate,
    (XtPointer) 3
  },
  {
    XtNmaxVariationBasePop,
    XtCMaxVariationBasePop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_variation_base_pop),
    XtRImmediate,
    (XtPointer) 3
  },
  {
    XtNminVariationJovianPop,
    XtCMinVariationJovianPop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, min_variation_jovian_pop),
    XtRImmediate,
    (XtPointer) 3
  },
  {
    XtNmaxVariationJovianPop,
    XtCMaxVariationJovianPop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_variation_jovian_pop),
    XtRImmediate,
    (XtPointer) 3
  },
  {
    XtNminVariationStarPop,
    XtCMinVariationStarPop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, min_variation_star_pop),
    XtRImmediate,
    (XtPointer) 5
  },
  {
    XtNmaxVariationStarPop,
    XtCMaxVariationStarPop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_variation_star_pop),
    XtRImmediate,
    (XtPointer) 5
  },
  {
    XtNminVariationBlackholePop,
    XtCMinVariationBlackholePop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, min_variation_blackhole_pop),
    XtRImmediate,
    (XtPointer) 4
  },
  {
    XtNmaxVariationBlackholePop,
    XtCMaxVariationBlackholePop,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_variation_blackhole_pop),
    XtRImmediate,
    (XtPointer) 4
  },
  {
    XtNforeground,
    XtCForeground,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, foreground),
    XtRString,
    XtDefaultForeground
  },
  {
    XtNbackground,
    XtCBackground,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, background),
    XtRString,
    XtDefaultBackground
  },
  {
    XtNendeverColor,
    XtCEndeverColor,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, endever_color),
    XtRString,
    XtDefaultForeground
  },
  {
    XtNendeverIcon,
    XtCEndeverIcon,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, endever_icon),
    XtRImmediate,
    (XtPointer) ">-0"
  },
  {
    XtNjovianColor,
    XtCJovianColor,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, jovian_color),
    XtRString,
    XtDefaultForeground
  },
  {
    XtNjovianIcon,
    XtCJovianIcon,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, jovian_icon),
    XtRImmediate,
    (XtPointer) "<*>"
  },
  {
    XtNbaseColor,
    XtCBaseColor,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, base_color),
    XtRString,
    XtDefaultForeground
  },
  {
    XtNbaseIcon,
    XtCBaseIcon,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, base_icon),
    XtRImmediate,
    (XtPointer) "+0+"
  },
  {
    XtNstarColor,
    XtCStarColor,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, star_color),
    XtRString,
    XtDefaultForeground
  },
  {
    XtNstarIcon,
    XtCStarIcon,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, star_icon),
    XtRImmediate,
    (XtPointer) "."
  },
  {
    XtNblackholeColor,
    XtCBlackholeColor,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, blackhole_color),
    XtRString,
    XtDefaultForeground
  },
  {
    XtNblackholeIcon,
    XtCBlackholeIcon,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, blackhole_icon),
    XtRImmediate,
    (XtPointer) " "
  },
  {
    XtNfaserColor,
    XtCFaserColor,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, faser_color),
    XtRString,
    XtDefaultForeground
  },
  {
    XtNfaserWidth,
    XtCFaserWidth,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, faser_width),
    XtRImmediate,
    (XtPointer) 9
  },
  {
    XtNfaserDashOffset,
    XtCFaserDashOffset,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, faser_dash_offset),
    XtRImmediate,
    (XtPointer) 0
  },
  {
    XtNfaserDashList,
    XtCFaserDashList,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, faser_dash_list),
    XtRImmediate,
    (XtPointer) "4 4"
  },
  {
    XtNfaserSpeed,
    XtCFaserSpeed,
    XtRLong,			// must use an Xmu converter for this type
    sizeof(long),
    XtOffsetOf(AppData, faser_speed),
    XtRImmediate,
    (XtPointer) 15L
  },
  {
    XtNtorpedoColor,
    XtCTorpedoColor,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, torpedo_color),
    XtRString,
    XtDefaultForeground
  },
  {
    XtNtorpedoWidth,
    XtCTorpedoWidth,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, torpedo_width),
    XtRImmediate,
    (XtPointer) 9
  },
  {
    XtNtorpedoLength,
    XtCTorpedoLength,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, torpedo_length),
    XtRImmediate,
    (XtPointer) 6
  },
  {
    XtNtorpedoSpeed,
    XtCTorpedoSpeed,
    XtRLong,			// must use an Xmu converter for this type
    sizeof(long),
    XtOffsetOf(AppData, torpedo_speed),
    XtRImmediate,
    (XtPointer) 30L
  },
  {
    XtNexplosionColor,
    XtCExplosionColor,
    XtRPixel,
    sizeof(Pixel),
    XtOffsetOf(AppData, explosion_color),
    XtRString,
    XtDefaultForeground
  },
  {
    XtNexplosionSpeed,
    XtCExplosionSpeed,
    XtRLong,			// must use an Xmu converter for this type
    sizeof(long),
    XtOffsetOf(AppData, explosion_speed),
    XtRImmediate,
    (XtPointer) 20L
  },
  {
    XtNexplosionRadiusSmall,
    XtCExplosionRadiusSmall,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, explosion_radius_small),
    XtRImmediate,
    (XtPointer) 35
  },
  {
    XtNexplosionRadiusBig,
    XtCExplosionRadiusBig,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, explosion_radius_big),
    XtRImmediate,
    (XtPointer) 120
  },
  {
    XtNendeverThrustSpeed,
    XtCEndeverThrustSpeed,
    XtRLong,			// must use an Xmu converter for this type
    sizeof(long),
    XtOffsetOf(AppData, endever_thrust_speed),
    XtRImmediate,
    (XtPointer) 100L
  },
  {
    XtNshipEnergizeSpeed,
    XtCShipEnergizeSpeed,
    XtRLong,			// must use an Xmu converter for this type
    sizeof(long),
    XtOffsetOf(AppData, ship_energize_speed),
    XtRImmediate,
    (XtPointer) 3000L
  },
  {
    XtNjovianActionSpeed,
    XtCJovianActionSpeed,
    XtRLong,			// must use an Xmu converter for this type
    sizeof(long),
    XtOffsetOf(AppData, jovian_action_speed),
    XtRImmediate,
    (XtPointer) 100L
  },
  {
    XtNselfDestructCode,
    XtCSelfDestructCode,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, self_destruct_code),
    XtRImmediate,
    (XtPointer) "123"
  },
  {
    XtNdefaultFiringAngle,
    XtCDefaultFiringAngle,
    XtRFloat,
    sizeof(float),
    XtOffsetOf(AppData, default_firing_angle),
    XtRString,
    (XtPointer) "0.0"
  },
  {
    XtNmaxTorpedoes,
    XtCMaxTorpedoes,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_torpedoes),
    XtRImmediate,
    (XtPointer) 10
  },
  {
    XtNmaxJoviansPerSector,
    XtCMaxJoviansPerSector,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_jovians_per_sector),
    XtRImmediate,
    (XtPointer) 3
  },
  {
    XtNmaxStarsPerSector,
    XtCMaxStarsPerSector,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, max_stars_per_sector),
    XtRImmediate,
    (XtPointer) 5
  },
  {
    XtNmaskProbability,
    XtCMaskProbability,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, mask_probability),
    XtRImmediate,
    (XtPointer) 5
  },
  {
    XtNminJovianDistance,
    XtCMinJovianDistance,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, min_jovian_distance),
    XtRImmediate,
    (XtPointer) 150
  },
  {
    XtNendeverMinFaserEnergy,
    XtCEndeverMinFaserEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, endever_min_faser_energy),
    XtRImmediate,
    (XtPointer) 10
  },
  {
    XtNendeverMinWarpEnergy,
    XtCEndeverMinWarpEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, endever_min_warp_energy),
    XtRImmediate,
    (XtPointer) 20
  },
  {
    XtNendeverMinThrustEnergy,
    XtCEndeverMinThrustEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, endever_min_thrust_energy),
    XtRImmediate,
    (XtPointer) 10
  },
  {
    XtNjovianMinFaserEnergy,
    XtCJovianMinFaserEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, jovian_min_faser_energy),
    XtRImmediate,
    (XtPointer) 10
  },
  {
    XtNjovianMinWarpEnergy,
    XtCJovianMinWarpEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, jovian_min_warp_energy),
    XtRImmediate,
    (XtPointer) 20
  },
  {
    XtNjovianMinThrustEnergy,
    XtCJovianMinThrustEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, jovian_min_thrust_energy),
    XtRImmediate,
    (XtPointer) 10
  },
  {
    XtNjovianThrustRetreatEnergy,
    XtCJovianThrustRetreatEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, jovian_thrust_retreat_energy),
    XtRImmediate,
    (XtPointer) 30
  },
  {
    XtNjovianWarpRetreatEnergy,
    XtCJovianWarpRetreatEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, jovian_warp_retreat_energy),
    XtRImmediate,
    (XtPointer) 40
  },
  {
    XtNjovianFaserRetreatEnergy,
    XtCJovianFaserRetreatEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, jovian_faser_retreat_energy),
    XtRImmediate,
    (XtPointer) 30
  },
  {
    XtNjovianShieldRetreatEnergy,
    XtCJovianShieldRetreatEnergy,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, jovian_shield_retreat_energy),
    XtRImmediate,
    (XtPointer) 40
  },
  {
    XtNjovianRetreatProbability,
    XtCJovianRetreatProbability,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, jovian_retreat_probability),
    XtRImmediate,
    (XtPointer) 50
  },
  {
    XtNjovianRetreatSpeed,
    XtCJovianRetreatSpeed,
    XtRFloat,
    sizeof(float),
    XtOffsetOf(AppData, jovian_retreat_speed),
    XtRString,
    (XtPointer) "1.0"
  },
  {
    XtNjovianMinFightFrequency,
    XtCJovianMinFightFrequency,
    XtRFloat,
    sizeof(float),
    XtOffsetOf(AppData, jovian_min_fight_frequency),
    XtRString,
    (XtPointer) "3.5"
  },
  {
    XtNjovianMaxFightFrequency,
    XtCJovianMaxFightFrequency,
    XtRFloat,
    sizeof(float),
    XtOffsetOf(AppData, jovian_max_fight_frequency),
    XtRString,
    (XtPointer) "1.5"
  },
  {
    XtNjovianMinRaidFrequency,
    XtCJovianMinRaidFrequency,
    XtRFloat,
    sizeof(float),
    XtOffsetOf(AppData, jovian_min_raid_frequency),
    XtRString,
    (XtPointer) "400.0"
  },
  {
    XtNjovianMaxRaidFrequency,
    XtCJovianMaxRaidFrequency,
    XtRFloat,
    sizeof(float),
    XtOffsetOf(AppData, jovian_max_raid_frequency),
    XtRString,
    (XtPointer) "40.0"
  },
  {
    XtNjovianMinLeapFrequency,
    XtCJovianMinLeapFrequency,
    XtRFloat,
    sizeof(float),
    XtOffsetOf(AppData, jovian_min_leap_frequency),
    XtRString,
    (XtPointer) "400.0"
  },
  {
    XtNjovianMaxLeapFrequency,
    XtCJovianMaxLeapFrequency,
    XtRFloat,
    sizeof(float),
    XtOffsetOf(AppData, jovian_max_leap_frequency),
    XtRString,
    (XtPointer) "40.0"
  }
};

#endif				// _XPREP_

// end
