/* 
 *	xtrojka v 1.1	(c) 1994,1995 Maarten Los
 *	#include "COPYRIGHT"
 *
 *
 *	handlers for action keys
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "xtrojka.h"


extern toggle_score_status();
extern toggle_auto_position();
extern quit_appl();
extern gameover();
extern set_state();


extern Widget form;
extern XtAppContext app_context;

void new_game();


/*
 * 	actions
 */


XtActionsRec always_actions[] =
{
	{ "Status", (XtActionProc)toggle_score_status },
	{ "AutoPos", (XtActionProc)toggle_auto_position },
	{ "Quitgame", (XtActionProc)quit_appl }
};

XtActionsRec play_actions[] =
{
	{ "Abort", (XtActionProc)gameover }
};


XtActionsRec idle_actions[] =
{
	{ "New", (XtActionProc)new_game }
};


/*
 * 	translations to activate the actions
 */

static String always_trans =
	"Alt<Key>S:Status()\n\
	 Ctrl<Key>S:Status()\n\
	 Meta<Key>S:Status()\n\
	 Alt<Key>P:AutoPos()\n\
	 Ctrl<Key>P:AutoPos()\n\
	 Meta<Key>P:AutoPos()\n\
	 Alt<Key>X:Quitgame()\n\
	 Ctrl<Key>X:Quitgame()\n\
	 Meta<Key>X:Quitgame()\n\
	 Alt<Key>Q:Quitgame()\n\
	 Ctrl<Key>Q:Quitgame()\n\
	 Meta<Key>Q:Quitgame()\n";

static String play_trans =
	"Alt<Key>A:Abort()\n\
	 Ctrl<Key>A:Abort()\n\
	 Meta<Key>A:Abort()\n";

static String idle_trans =
	"Alt<Key>N:New()\n\
	 Ctrl<Key>N:New()\n\
	 Meta<Key>N:New()\n";




init_actions()
{
	XtAppAddActions(app_context, always_actions, XtNumber(always_actions));
	XtOverrideTranslations(form, 
			XtParseTranslationTable(always_trans));
}


set_action_handlers(gs)
enum gamestate gs;
{
	if(gs == st_playing) {
		XtAppAddActions(app_context,
				play_actions, XtNumber(play_actions));
		XtOverrideTranslations(form, 
				XtParseTranslationTable(play_trans));
	} else {
		XtAppAddActions(app_context,
				idle_actions, XtNumber(idle_actions));
		XtOverrideTranslations(form, 
				XtParseTranslationTable(idle_trans));
	}
}

void new_game()
{
	set_state(st_playing);
}

