/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 * 	handler for dealing with the highscore table
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>
#include <pwd.h>
#include "hiscore.h"
#include "xtrojka.h"


SCORES scores[NUMSCORES];
SCORES old_scores[NUMSCORES];
SCORES cur;

extern unsigned long
	score,
	wipes,
	blocks;		/* trojka */

extern int
	speed;

extern flag is_score_status;
extern flag is_wizard;
extern time_t last_time;
extern char changed[NUMSCORES];

extern int errno;

int position;


int do_hiscores()
{
	int i;
	char hostname[20];
	char username[20];
	char changed;

	position = NUMSCORES+1;
	
	copy_oldscores();
	read_scores();

	/* see if there is a highscore */
	if(is_hiscore()) {

		shift_scores();
		
		gethostname(hostname,20);
		
		scores[position].score = score;
		scores[position].date = time(0);
		scores[position].speed = speed;
		scores[position].user = getuid();
		scores[position].wizard = is_wizard;
		strcpy(scores[position].host, hostname);
		memcpy((char*)&cur, (char*)&scores[position], sizeof(cur));

		write_scores();
		utime(SCOREFILE, NULL);
		sleep(1);
		last_time = 0;
		file_changed(SCOREFILE);
		
	} else {
		memset((char*)&cur, 0, sizeof(cur));
	}
	compare_scores();

	if(!is_score_status) {
		show_score_status();
	}
	draw_score_status();
}


is_hiscore()
{
	int i;

	for(i = 0; i < NUMSCORES; i++)
		if(score > scores[i].score) {
			position = i;
			return 1;
		}
	return 0;
}


shift_scores()
{
	int i;

	for(i = NUMSCORES-1; i > position; i--)
		scores[i] = scores[i-1];
}


int read_scores()
{
	int i;
	int fd;

	/* clear scores */

	for(i = 0; i < NUMSCORES; i++) {
		scores[i].score = NO_SCORE;
	}

	if((fd = open(SCOREFILE, O_RDONLY)) < 0) {
		create_scorefile();
		write_scores();
	} else 
	if(read(fd, scores, sizeof(scores)) < 0) {
		fprintf(stderr,"read_scores: cannot read scores\n");
		exit(1);
	}

	close(fd);
}



int write_scores()
{
	int fd;

	if((fd = open(SCOREFILE, O_WRONLY)) < 0) {
		fprintf(stderr,"write_scores: cannot open '%s'\n", SCOREFILE);
		exit(1);
	}

#ifdef LOCKING
	if(lockf(fd, F_LOCK, sizeof(scores)) < 0) {
		fprintf(stderr,"WARNING: write_scores: cannot lock section. (%d)\n",
			errno);
	}
#endif
	if(write(fd, scores, sizeof(scores)) < 0) {
		fprintf(stderr,"write_scores: cannot write scores\n");
		exit(1);
	}

	close(fd);
}


int create_scorefile()
{
	int fd;
	int oldumask = umask(0);

	if((fd = creat(SCOREFILE, 0666)) < 0) {
		fprintf(stderr,"Cannot create scorefile: %s\n", SCOREFILE);
		exit(1);
	}
	
	umask(oldumask);
}



