/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	builds the wizard fields
 */

#include <stdio.h>

#include "xtrojka.h"
#include "screen.h"

#define LAYOUTS		42

extern int field[VIRT_XSIZE][VIRT_YSIZE];
extern unsigned long score;
extern flag is_gaps;
extern flag is_wizard;

int ran_q_ptr;
int ran_q[LAYOUTS];

int cur_layout;

unsigned long wizard_switch;

static int Layout[LAYOUTS][5] =
{
	{ 011331, 024413, 040000,      0,      0 },
	{ 010101, 040303, 010101, 040303, 010101 },
	{ 001210, 040004, 030003, 030003, 002120 },
	{ 010101, 000003, 030303, 000000, 040404 },
	{ 020202, 005050, 040404, 003030, 010101 },
	{ 035353, 041014, 040204,      0,      0 },
	{ 054245, 050005, 050005, 002020, 000200 },
	{ 010001, 031013, 011011, 031013, 010001 },
	{ 030003, 001130, 003110, 001130, 030003 },
	{ 011511, 040004, 020202, 040004, 011511 },
	{ 025341, 050000, 030350, 040010, 014320 },
	{ 010201, 021212, 003003, 001010, 010001 },
	{ 000300, 000300, 000300, 000300, 054345 },
	{      0, 005050, 033133, 005050,      0 },
	{ 000400, 000300, 000200, 000300, 000400 },
	{ 000300, 001010, 040004, 001010, 000300 },
	{ 013531, 002520, 000400, 002520, 013531 },
	{ 000300, 000400, 010501, 005050, 000500 },
	{ 000200, 000400, 033533, 000400, 000200 },
	{ 030303, 001010, 000400, 000200, 000200 },
	{ 010001, 003030, 000100, 003030, 010001 },
	{ 004240, 030003,      0, 004040,      0 },
	{ 000100, 004040, 030303, 020202, 050505 },
	{ 050505, 053535, 003030, 023232, 020202 },
	{ 055355, 005000, 000300, 000050, 055355 },
	{ 053535, 030203, 052525, 030203, 053535 },
	{ 052505, 030303, 010101, 030303, 050525 },
	{      0,      0,      0,      0, 055455 },
	{ 004253,      0, 031450,      0, 002143 },
	{ 053035, 002120, 053035, 002120, 053035 },
	{ 012121, 004340, 000300, 004340, 012121 },
	{ 005250, 020502, 012021, 020502, 005250 },
	{ 011022, 011022,      0, 033055, 033055 },
	{ 010001, 053035, 012421, 053035, 010001 },
	{ 043035, 020003, 020003, 020003, 043035 },
	{ 000055, 003300, 020000, 001100, 000044 },
	{ 033033, 000500, 005050, 002020, 004040 },
	{ 011000, 001100, 000440, 000044,      0 },
	{ 010001, 000300, 003530, 000300, 010001 },
	{ 000550, 000550, 033000, 033000,      0 },
	{ 055055, 044044, 033033, 022022, 011011 },
	{ 055110, 033550, 022330, 044220, 011440 }
};


int build_layout()
{
	int x,y;
	int pattern;
	unsigned char block;

#define MASK	0x03


	for(y = PLM_BOTTOM; y < (PLM_BOTTOM + 5); y++) {
		for(x = 0; x < BLOCKS; x++) {
			pattern = Layout[cur_layout][y-1];
			block = (pattern >> (x*3)) & MASK;
			if((block >= 0) && (block <= 5)) {
				makeblock(x, y, block);
				field[x][y] = block;
			} else {
				if(block != 0) {
					fprintf(stderr,"Layout error!\n");
					exit(1);
				}
			}
		}
	}
}




int init_random_q()
{
	int i;

	srand(time(0));
	
	ran_q_ptr = LAYOUTS;
	for(i = 0; i < ran_q_ptr; i++)
		ran_q[i] = i;
}


int get_qrandom()
{
	int rnd;

	rnd = ran_q[rand() % ran_q_ptr];

	ran_q[rnd] = ran_q[--ran_q_ptr];
	ran_q[ran_q_ptr] = rnd;

	if(!ran_q_ptr)
		init_random_q();

	return(rnd);
}


int check_wizard(l)
int l;
{
	if(!is_wizard)
		return 0;

	if((!is_gaps) && (score > wizard_switch) && (l < PLM_BOTTOM + 5)) {
		cur_layout = get_qrandom();
		build_layout();	
		wizard_switch = score + ((rand() % 10) * 500) + 2000;
	}	
}
