/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 * 	This module does the handling of keys and dropping blocks
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

#include "xtrojka.h"
#include "screen.h"

extern XtAppContext app_context;

extern Widget main_screen;		/* the mother of all widgets */
extern Widget score_status_screen;
extern Widget screen;
extern Widget form;
extern Widget about_shell, about_screen;

extern unsigned long score;

extern flag is_score_status;
extern flag is_about;
extern flag is_wizard;

extern int xpos, ypos;
extern int last_xpos, last_ypos;
extern int shape;
extern int blocks;
extern int speedbonus;
extern int Pause;
extern int speed;
extern int field[VIRT_XSIZE][VIRT_YSIZE];

extern enum gamestate game_state;

extern void redraw_about_hlr();

/*
 * event handlers 
 */

void game_key_pressed_hlr();	/* for keypressed if playing  */
void idle_key_pressed_hlr();	/* for keypressed if idle */
void block_down_hlr();		/* for timeout */
void leave_window_hlr();	/* for window leaves */
void enter_window_hlr();	/* for window enterings */
void move_mainwindow_hlr();	/* if main window is moved */
void about_button_hlr();	/* if button is pressed in aboutbox */


static XtIntervalId clocker;


flag paused;
flag ignore_clock;
flag remove_clock;




mainloop()
/*
 * this is the main loop where the game is played 
 */
{
	XEvent event;

	resetblock();
	set_state(st_idle);

	for(;;) {
		XtAppNextEvent(app_context, &event);
		XtDispatchEvent(&event);
	}
}



void game_key_pressed_hlr(w, unused, ke, continue_to_dispatch)
Widget w;
register XKeyPressedEvent *ke;
XtPointer unused;
Boolean *continue_to_dispatch;
{
/*
 *	this function is a callback function. It is called each time
 *	a key is pressed when playing.
 */

	Modifiers dum;
	Modifiers modmask;
	char key[90];
	KeySym sym;
	KeySym ctrl_sym;

	*continue_to_dispatch = TRUE;
	if(ke->type != KeyPress)
		return;
	 
	XtTranslateKeycode(ke->display, ke->keycode, 0, &dum, &sym);
	
	switch(sym) {
	  case XK_h:
	  case XK_Left:
		if(ignore_clock)
			return;
		if((xpos > 0) && (field[xpos-1][ypos] == CLEAR)) {
			wipeblock(xpos, ypos); 
			xpos--;
			last_xpos = xpos;
			makeblock(xpos, ypos, shape); 
		}
		break;

	  case XK_l:
	  case XK_Right:
		if(ignore_clock)
			return;
		if((xpos < VIRT_XSIZE-1) && (field[xpos+1][ypos] == CLEAR)) {
			wipeblock(xpos, ypos);
			xpos++;
			last_xpos = xpos;
			makeblock(xpos, ypos, shape);
		}
		break;

	  case XK_space:
	  case XK_j:
	  case XK_Insert:
	  case XK_Down:
		if(ignore_clock)
			return;

		dropblock();
		break;
	 	 
	  case XK_Up:
	  case XK_k:
		speedup();
		disable_speedmenu(speed);
		break;

	  default:
		break;
	}	
}


void idle_key_pressed_hlr(w, unused, ke, continue_to_dispatch)
Widget w;
register XKeyPressedEvent *ke;
XtPointer unused;
Boolean *continue_to_dispatch;
{
/*
 *	this function is a callback function. It is called each time
 *	a key is pressed when idle.
 */

	Modifiers dum;
	char key[90];
	KeySym sym;

	*continue_to_dispatch = TRUE;
	if(ke->type != KeyPress)
		return;
	 
	XtTranslateKeycode(ke->display, ke->keycode, 0, &dum, &sym);

	switch(sym) {
	  case XK_y:
		exit(0);
		break;

	  default:
		break;
	}	
}

void block_down_hlr(w, id)
Widget w;
XtIntervalId *id;
{
/*
 *	this function is called every n timer ticks depending
 *	on the game speed. 
 */
	int stackl;

	if(!remove_clock)
		clocker=XtAppAddTimeOut(app_context, Pause, block_down_hlr, 0);
	else {
		remove_clock = 0;
		return;
	}

	if(ignore_clock)	
		return;

	ypos--;
	if(field[xpos][ypos] != CLEAR) {
		field[xpos][ypos+1] = shape;
		resetblock();
		blocks++;
		check_speed();
		multscore((unsigned long)shape);
		if((stackl = scan()) == PLM_TOP)
			gameover();
		else 
		check_wizard();
		show_score();
	} else {
		wipeblock(xpos, ypos+1);
		makeblock(xpos, ypos, shape);
	}
}


void move_mainwindow_hlr(w, unused, ce, continue_to_dispatch)
Widget w;
register XConfigureEvent *ce;
XtPointer unused;
Boolean *continue_to_dispatch;
{
	*continue_to_dispatch = TRUE;

	if(ce->type == ConfigureNotify) {
		if((game_state == st_idle) || (is_score_status)) {
			show_score_status();
		}
	}
}	
	
	
void about_button_hlr(w, unused, be, continue_to_dispatch)
Widget w;
register XButtonEvent *be;
XtPointer unused;
Boolean *continue_to_dispatch;
{
	*continue_to_dispatch = TRUE;

	if((be->type == ButtonPress) && (is_about)) {
		XtPopdown(about_shell);
		XtRemoveEventHandler(about_screen, ButtonPressMask, False,
			about_button_hlr, (Opaque)NULL);
		XtRemoveEventHandler(about_screen, ExposureMask, False,
			redraw_about_hlr, (Opaque)NULL);
		is_about = 0;
	}
}


int dropblock()
{
/*
 *	drop a block immediately
 */
	score += (unsigned long)((ypos * speedbonus) / 5);

	wipeblock(xpos, ypos);
	while(field[xpos][ypos] == CLEAR)
		ypos--;
	ypos++;
	makeblock(xpos, ypos, shape);
}


int gameover()
{
	remove_clock = 1;	
	set_state(st_idle);
	do_hiscores();
}



void leave_window_hlr(w, unused, lw, continue_to_dispatch)
Widget w;
register XLeaveWindowEvent *lw;
XtPointer unused;
Boolean *continue_to_dispatch;
{
/*
 *	this function is a callback function. It is called each time
 *	the mouse pointer leaves the window
 */

	*continue_to_dispatch = TRUE;
	
	ignore_clock = 1;
} 

void enter_window_hlr(w, unused, lw, continue_to_dispatch)
Widget w;
register XEnterWindowEvent *lw;
XtPointer unused;
Boolean *continue_to_dispatch;
{
/*
 *	this function is a callback function. It is called each time
 *	the mouse pointer enter the window
 */

	*continue_to_dispatch = TRUE;
	
	ignore_clock = 0;
} 



int set_state(gs)
enum gamestate gs;
{
/*
 *	disables/enables menu's event- and update handlers
 *	depending on the game state.
 */

	game_state = gs;
	set_event_handlers(gs);
	set_redraw_handlers(gs);
	set_action_handlers(gs);
	set_menus(gs);
	if(gs == st_playing) {
		resetgame();
		if(is_wizard)
			build_layout();
		draw_field();
		if(!is_score_status) {
			hide_score_status();
		}
	}
	else if(gs == st_idle)
		draw_title();	
}


int set_event_handlers(gs)
enum gamestate gs;
{
	/* set handler for moving of trojka window */
	XtRemoveEventHandler(main_screen, StructureNotifyMask, False,
		move_mainwindow_hlr, (Opaque)NULL);
	XtAddEventHandler(main_screen, StructureNotifyMask, False,
		move_mainwindow_hlr, (Opaque)NULL);

	if(gs == st_playing) {

		remove_clock = 0;

		clocker = XtAppAddTimeOut(app_context,
			Pause,
			block_down_hlr,
			0);


		/* set handler for keyboard */
		XtAddEventHandler(form,
			KeyPressMask,
			False,
			game_key_pressed_hlr,
			(Opaque)NULL
		);

		XtRemoveEventHandler(form,
			KeyPressMask,
			False,
			idle_key_pressed_hlr,
			(Opaque)NULL
		);

		/* set handler if the pointer leaves the window */
		XtAddEventHandler(screen,
			LeaveWindowMask,
			False,
			leave_window_hlr,
			(Opaque)NULL
		);

		/* set handler if the pointer enters the window */
		XtAddEventHandler(screen,
			EnterWindowMask,
			False,
			enter_window_hlr,
			(Opaque)NULL
		);

	} else
	if(gs == st_idle) {
	
		remove_clock = 1;

		XtRemoveEventHandler(form,
			KeyPressMask,
			False,
			game_key_pressed_hlr,
			(Opaque)NULL
		);

		XtAddEventHandler(form,
			KeyPressMask,
			False,
			idle_key_pressed_hlr,
			(Opaque)NULL
		);
		
		XtRemoveEventHandler(screen,
			LeaveWindowMask,
			False,
			leave_window_hlr,
			(Opaque)NULL
		);

		XtRemoveEventHandler(screen,
			EnterWindowMask,
			False,
			enter_window_hlr,
			(Opaque)NULL
		);
	}
}


