/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *      menu handler for xtrojka
 */

#ifdef DEBUG
#include <stdio.h>		/* for stderr */
#endif

#include "menu.h"
#include "xtrojka.h"

extern flag is_wizard;
extern flag is_auto_position;

extern int speed;
extern int oldspeed;

extern enum gamestate game_state;

void handle_trojkamenu(item)
int item;
{
	enum gamestate d;

	d = st_playing;
	switch(item) {
		case trojka_Mnewgame:
			set_state(d);
			break;
		case trojka_Mabortgame:
			gameover();		
			break;
		case trojka_Mabout:
			show_about();
			break;
		case trojka_Mquit:
			quit_appl();
			break;
	}		
}


void handle_optionsmenu(item)
int item;
{
	switch(item) {
		case options_Mscore_status:
			toggle_score_status();
			break;
		case options_Mauto_position:
			is_auto_position = !is_auto_position;
			check_auto_position_item(is_auto_position);
			break;
		case options_Mwizardmode:
			is_wizard = !is_wizard;
			check_wizard_item(is_wizard);
			break;
	}
}


void handle_speedmenu(item)
int item;
{
	speed = item;
	set_speed(speed);
	if(game_state == st_playing)
		disable_speedmenu(speed);
	oldspeed = speed;
}


enable_speedmenu()
{
	int i;

	for(i = 0; i < SPEEDMENU_ITEMS; i++)
		enable(speed_M, i, 1);
}


disable_speedmenu(speed)
int speed;
{
	int i;

	for(i = 0; i < speed; i++) {
		enable(speed_M, i, 0);
	}
	for(i = speed; i < SPEEDMENU_ITEMS; i++) {
		enable(speed_M, i, 1);
	}
}


set_speed_item(speed)
int speed;
{
	int i;

	for(i = 0; i < SPEEDMENU_ITEMS; i++)
		check_speed_item(i,0);
	check_speed_item(speed,1);
}


int set_menus(gs)
enum gamestate gs;
{
/*
 *	enables/disables menus depending on game state.
 *	TrojkaMenu:
 *		abort game disabled if idle
 *		new game disabled if playing
 *		others always enabled
 *	OptionsMenu:
 *		wizard mode enabled if idle
 *		wizard mode disabled if in wizard mode and playing
 *	SpeedMenu:
 *		everything enabled if idle
 *		everything to currentspeed disabled in playing	
 */
	if(gs == st_playing) {
		enable(trojka_M, trojka_Mnewgame, 0);
		enable(trojka_M, trojka_Mabortgame, 1);
		if(is_wizard)
			enable(options_M, options_Mwizardmode, 0);
		disable_speedmenu(speed);
	} else 
	if(gs == st_idle) {
		speed = oldspeed;
		enable(trojka_M, trojka_Mnewgame, 1);
		enable(trojka_M, trojka_Mabortgame, 0);
		enable(options_M, options_Mwizardmode, 1);
		enable_speedmenu();
	}
}
