/*
 *	xtrojka v1.1 (c) 1994,1995 Maarten Los
 *
 *	#include "COPYRIGHT"	
 *
 *	initialization and building of the menu's
 */

#ifdef DEBUG
#include <stdio.h>		/* for stderr */
#endif

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>

#include "menu.h"

extern Widget main_screen;

Widget trojkamenu_but, trojkamenu_shell, trojkamenu, 
	trojkamenu_item[TROJKAMENU_ITEMS];
Widget optionsmenu_but, optionsmenu_shell, optionsmenu,
	optionsmenu_item[OPTIONSMENU_ITEMS];
Widget speedmenu_but, speedmenu_shell, speedmenu,
	speedmenu_item[SPEEDMENU_ITEMS];


ITEMLIST trojkamenu_ilist[TROJKAMENU_ITEMS] = {
	{ "trojkamenu_item0",	"New Game    \244 N " },
	{ "trojkamenu_item1",	"Abort Game  \244 A " },
	{ "trojkamenu_item2",	"----------------" },
	{ "trojkamenu_item3",	"About Trojka... " },
	{ "trojkamenu_item4",	"----------------" },
	{ "trojkamenu_item5",	"Quit        \244 Q " }
};

ITEMLIST optionsmenu_ilist[OPTIONSMENU_ITEMS] = {
	{ "optionsmenu_item0",	"  Score Status  \244 S " },
	{ "optionsmenu_item1",  "  Auto position \244 P " },
	{ "optionsmenu_item2",	"--------------------" },
	{ "optionsmenu_item3",	"  Wizard            " }
};

ITEMLIST speedmenu_ilist[SPEEDMENU_ITEMS] = {
	{ "speedmenu_item0",	"  0 Boring     " },
	{ "speedmenu_item1",	"  1            " },
	{ "speedmenu_item2",	"  2 Slow       " },
	{ "speedmenu_item3",	"  3            " },
	{ "speedmenu_item4",	"  4            " },
	{ "speedmenu_item5",	"  5 Normal     " },
	{ "speedmenu_item6",	"  6            " },
	{ "speedmenu_item7",	"  7 Fast       " },
	{ "speedmenu_item8",	"  8            " },
	{ "speedmenu_item9",	"  9 Nerd Speed " }
};
	

init_menus()
{
/*
 *	this function inits the menus' for xtrojka
 */
	init_trojkamenu();
	init_optionsmenu();
	init_speedmenu();
}

init_trojkamenu()
{
/*
 *	this function inits the trojkamenus
 */
	int i;
	XtTranslations mytrans;


	trojkamenu_shell = XtCreatePopupShell(
		"trojkamenu_shell",
		overrideShellWidgetClass,
		trojkamenu_but,
		NULL,
		0
	);

	trojkamenu = XtVaCreateManagedWidget(
		"trojkamenu",
		boxWidgetClass,
		trojkamenu_shell,
		XtNhSpace, 0,
		XtNvSpace, 0,
		NULL
	);

	mytrans = XtParseTranslationTable(
		"<EnterWindow>: set() \n\
		 <LeaveWindow>: unset() \n\
		 <BtnDown>: notify() unset()"
	);
	for(i = 0; i < TROJKAMENU_ITEMS; i++) {
		trojkamenu_item[i] = XtVaCreateManagedWidget(
			trojkamenu_ilist[i].id,
			commandWidgetClass,
			trojkamenu,
			XtNborderWidth, 0,
			XtNlabel, trojkamenu_ilist[i].label,
			NULL
		);
		if(trojkamenu_ilist[i].label[0] != '-') {
			XtAddCallback(trojkamenu_item[i],
				XtNcallback,
				trojkamenu_select_hlr,
				(XtPointer)i);
			XtOverrideTranslations(trojkamenu_item[i], mytrans);
		} else
			enable(trojka_M, i, 0);
	}

	mytrans = XtParseTranslationTable(
		"<EnterWindow>: highlight() \n\
		 <LeaveWindow>: reset() \n\
		 <BtnDown>: set() XtMenuPopup(trojkamenu_shell) reset()"
		);
	XtOverrideTranslations(trojkamenu_but, mytrans);

	mytrans = XtParseTranslationTable(
		"<BtnUp>: XtMenuPopdown(trojkamenu_shell) ");
	XtOverrideTranslations(trojkamenu_shell, mytrans);

	XtAddCallback(trojkamenu_shell,
		XtNpopupCallback,
		trojkamenu_show_hlr,
		0
	);
}

init_optionsmenu()
{
/*
 *	this function inits the options menu
 */
	int i;
	XtTranslations mytrans;


	optionsmenu_shell = XtCreatePopupShell(
		"optionsmenu_shell",
		overrideShellWidgetClass,
		optionsmenu_but,
		NULL,
		0
	);

	optionsmenu = XtVaCreateManagedWidget(
		"optionsmenu",
		boxWidgetClass,
		optionsmenu_shell,
		XtNhSpace, 0,
		XtNvSpace, 0,
		NULL
	);

	mytrans = XtParseTranslationTable(
		"<EnterWindow>: set() \n\
		 <LeaveWindow>: unset() \n\
		 <BtnDown>: notify() unset()"
	);
	for(i = 0; i < OPTIONSMENU_ITEMS; i++) {
		optionsmenu_item[i] = XtVaCreateManagedWidget(
			optionsmenu_ilist[i].id,
			commandWidgetClass,
			optionsmenu,
			XtNborderWidth, 0,
			XtNlabel, optionsmenu_ilist[i].label,
			NULL
		);
		if(optionsmenu_ilist[i].label[0] != '-') {
			XtAddCallback(optionsmenu_item[i],
				XtNcallback,
				optionsmenu_select_hlr,
				(XtPointer)i);
			XtOverrideTranslations(optionsmenu_item[i], mytrans);
		} else
			enable(options_M, i, 0);
	}
	

	mytrans = XtParseTranslationTable(
		"<EnterWindow>: highlight() \n\
		 <LeaveWindow>: reset() \n\
		 <BtnDown>: set() XtMenuPopup(optionsmenu_shell) reset()"
		);
	XtOverrideTranslations(optionsmenu_but, mytrans);

	mytrans = XtParseTranslationTable(
		"<BtnUp>: XtMenuPopdown(optionsmenu_shell) ");
	XtOverrideTranslations(optionsmenu_shell, mytrans);

	XtAddCallback(optionsmenu_shell,
		XtNpopupCallback,
		optionsmenu_show_hlr,
		0
	);
}

init_speedmenu()
{
/*
 *	this function inits the speed menu
 */
	int i;
	XtTranslations mytrans;


	speedmenu_shell = XtCreatePopupShell(
		"speedmenu_shell",
		overrideShellWidgetClass,
		speedmenu_but,
		NULL,
		0
	);

	speedmenu = XtVaCreateManagedWidget(
		"speedmenu",
		boxWidgetClass,
		speedmenu_shell,
		XtNhSpace, 0,
		XtNvSpace, 0,
		NULL
	);

	mytrans = XtParseTranslationTable(
		"<EnterWindow>: set() \n\
		 <LeaveWindow>: unset() \n\
		 <BtnDown>: notify() unset()"
	);
	for(i = 0; i < SPEEDMENU_ITEMS; i++) {
		speedmenu_item[i] = XtVaCreateManagedWidget(
			speedmenu_ilist[i].id,
			commandWidgetClass,
			speedmenu,
			XtNborderWidth, 0,
			XtNlabel, speedmenu_ilist[i].label,
			NULL
		);
		if(speedmenu_ilist[i].label[0] != '-') {
			XtAddCallback(speedmenu_item[i],
				XtNcallback,
				speedmenu_select_hlr,
				(XtPointer)i);
			XtOverrideTranslations(speedmenu_item[i], mytrans);
		} else
			enable(speed_M, i, 0);
	}

	mytrans = XtParseTranslationTable(
		"<EnterWindow>: highlight() \n\
		 <LeaveWindow>: reset() \n\
		 <BtnDown>: set() XtMenuPopup(speedmenu_shell) reset()"
		);
	XtOverrideTranslations(speedmenu_but, mytrans);

	mytrans = XtParseTranslationTable(
		"<BtnUp>: XtMenuPopdown(speedmenu_shell) ");
	XtOverrideTranslations(speedmenu_shell, mytrans);

	XtAddCallback(speedmenu_shell,
		XtNpopupCallback,
		speedmenu_show_hlr,
		0
	);
}



/* ARGSUSED */
void trojkamenu_show_hlr(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	Position x,y;	
	Dimension height;

	XtTranslateCoords(trojkamenu_but, (Position)0, (Position)0, &x,&y);
	XtVaGetValues(trojkamenu_but, XtNheight, &height, NULL);
	XtVaSetValues(trojkamenu_shell, XtNx, x-1, XtNy, y+height, NULL);
}

/* ARGSUSED */
void optionsmenu_show_hlr(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	Position x,y;	
	Dimension height;

	XtTranslateCoords(optionsmenu_but, (Position)0, (Position)0, &x,&y);
	XtVaGetValues(optionsmenu_but, XtNheight, &height, NULL);
	XtVaSetValues(optionsmenu_shell, XtNx, x-1, XtNy, y+height, NULL);
}


/* ARGSUSED */
void speedmenu_show_hlr(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	Position x,y;	
	Dimension height;

	XtTranslateCoords(speedmenu_but, (Position)0, (Position)0, &x,&y);
	XtVaGetValues(speedmenu_but, XtNheight, &height, NULL);
	XtVaSetValues(speedmenu_shell, XtNx, x-1, XtNy, y+height, NULL);
}


/* ARGSUSED */
void trojkamenu_select_hlr(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	int item;

	XtPopdown(trojkamenu_shell);
	item = (int)client_data;
	handle_trojkamenu(item);
}

/* ARGSUSED */
void optionsmenu_select_hlr(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	int item;

	item = (int)client_data;
	XtPopdown(optionsmenu_shell);
	handle_optionsmenu(item);
}

/* ARGSUSED */
void speedmenu_select_hlr(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	int item;

	item = (int)client_data;
	XtPopdown(speedmenu_shell);
	handle_speedmenu(item);
}


int enable(menu, item, enabled)
int menu;
int item;
char enabled;
{
/*
 * 	enables or disables a menu-item
 */
	switch(menu) {
	case trojka_M:
		XtSetSensitive(trojkamenu_item[item], enabled);
		break;
	case options_M:
		XtSetSensitive(optionsmenu_item[item], enabled);
		break;
	case speed_M:
		XtSetSensitive(speedmenu_item[item], enabled);
		break;
	}
}
	
int check_score_status_item(checked) 
char checked;
{
/*
 *	(un)checks the score_status in the optionsmenu
 */
	optionsM_check_dispatch(checked, options_Mscore_status);
}


int check_auto_position_item(checked) 
char checked;
{
/*
 *	(un)checks the score_status in the optionsmenu
 */
	optionsM_check_dispatch(checked, options_Mauto_position);
}


int check_wizard_item(checked) 
char checked;
{
/*
 *	(un)checks the wizard item in the optionsmenu
 */
	optionsM_check_dispatch(checked, options_Mwizardmode);
}

int optionsM_check_dispatch(checked, item)
char checked;
int item;
{
	char label[100];

	strcpy(label, optionsmenu_ilist[item].label);
	label[0] = checked ? CHECKMARK : ' ';
	XtVaSetValues(optionsmenu_item[item],XtNlabel,label,NULL);
	strcpy(optionsmenu_ilist[item].label, label);
}

int check_speed_item(speed, on)
int speed;
char on;
/*
 *	(un)checks the menu item of speed
 */
{
	char label[100];

	strcpy(label, speedmenu_ilist[speed].label);
	label[0] = on ? CHECKMARK : ' ';
	XtVaSetValues(speedmenu_item[speed],XtNlabel,label,NULL);
	strcpy(speedmenu_ilist[speed].label, label);
}
